# Analiza Danych Produktów - Połączenia między Plikami

## Pliki CSV

### 1. **produkty-baza-produktów-2025-11-29.csv**
**Główna baza produktów** - zawiera definicje wszystkich produktów w systemie.

**Kluczowe kolumny:**
- `Nazwa` - nazwa produktu
- `Kategoria` - kategoria produktu  
- `Kod` - unikalny kod produktu
- `Cena` - cena produktu
- `Za ceną` - jednostka ceny (szt, kg, etc.)
- `Produkcja` - miejsce produkcji
- `Status` - status produktu (active/notactive)
- `ID pozycji` - unikalny identyfikator w Gravity Forms
- `Id` - ID produktu w systemie Gravity Forms
- `Faktor` - współczynnik produkcji
- `Jed. prod.` - jednostka produkcji

**Przykładowy wiersz:**
```csv
"szarlotka okrągła mała","","Ciasta","","","","Kościelisko","Ogólny","Kategoria","","","","","","","33366699","","","","active","","","","","","","","","166","484483","2025-11-23 15:20:29","2025-11-23 14:20:29",...
```

### 2. **systemowe-produkty-zamówienie-2025-11-29.csv**
**Produkty z zamówień** - zawiera produkty które były zamawiane przez klientów.

**Kluczowe kolumny:**
- `Ilość` - ilość zamówionego produktu
- `Nazwa` - nazwa produktu (dopasowanie do bazy)
- `Kategoria` - kategoria
- `Id` - ID produktu (dopasowanie do bazy)
- `Parent Entry ID` - ID zamówienia do którego należy produkt
- `ID pozycji` - ID pozycji tego produktu w zamówieniu

**Przykładowy wiersz:**
```csv
"15","Deser Panna Cotta","","Desery","","1362","170","486778","2025-11-29 07:49:58","2025-11-29 06:49:58",...,"","486779","7","5"
```

## Połączenia między Plikami

### Klucz Łączący: **Product Reference ID**

Produkty z obu plików łączą się przez ID produktu z systemu Gravity Forms:

**produkty-baza-produktów-*.csv**:
- `ID pozycji` (kolumna 30) - główny identyfikator produktu w bazie

**systemowe-produkty-zamówienie-*.csv**:  
- `Id` (kolumna 6) - identyfikator produktu który był zamówiony

**Przykład:**
Jeśli w baza-produktów jest produkt:
- Nazwa: "Deser Tiramisu"
- ID pozycji: 313253

To w systemowe-produkty może być:
- Nazwa: "Deser Tiramisu"  
- Id: 313253
- Ilość: 15
- Parent Entry ID: 486779

```
BAZA PRODUKTÓW                    PRODUKTY Z ZAMÓWIEŃ
+------------------+              +------------------+
| ID pozycji:      |              | Id: 313253       |
|   313253         |  <-------->  | Nazwa: "Deser    |
| Nazwa: "Deser    |      =       |  Tiramisu"       |
|  Tiramisu"       |              | Ilość: 15        |
| Kategoria:       |              | Parent Entry ID: |
|  "Desery"        |              |  486779          |
| Kod: ""          |              |                  |
| Status: active   |              |                  |
+------------------+              +------------------+
```

### Schemat Relacji

```
┌─────────────────────────────┐
│  PRODUKTY BAZA              │
│  (produkty-baza-*.csv)      │
│                             │
│  - Id (primary)             │
│  - Nazwa                    │
│  - Kategoria                │
│  - Kod                      │
│  - Cena                     │
│  - Status                   │
└──────────┬──────────────────┘
           │
           │ Id = Id
           │
           ▼
┌─────────────────────────────┐
│  PRODUKTY ZAMÓWIEŃ          │
│  (systemowe-produkty-*.csv) │
│                             │
│  - Id (foreign key)         │
│  - Nazwa                    │
│  - Ilość                    │
│  - Parent Entry ID          │
│  - Kategoria                │
└─────────────────────────────┘
```

## Mapowanie do Bazy Danych

### Tabela: `products`

```sql
CREATE TABLE products (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(50) NOT NULL,           -- Kod
    name VARCHAR(255) NOT NULL,          -- Nazwa
    description TEXT NULL,               -- Opis
    category_id INT NULL,                -- Kategoria (FK)
    price DECIMAL(10,2) NULL,            -- Cena
    price_unit VARCHAR(20) NULL,         -- Za ceną
    notes TEXT NULL,                     -- Uwagi
    production_site VARCHAR(100) NULL,   -- Produkcja
    factor DECIMAL(10,3) NULL,           -- Faktor
    production_unit VARCHAR(20) NULL,    -- Jed. prod.
    report_flags JSON NULL,
    sort_order INT DEFAULT 0,
    status VARCHAR(30) DEFAULT 'active', -- Status
    created_at TIMESTAMP,
    updated_at TIMESTAMP
);
```

### Przykład Mapowania Kolumn

| CSV Kolumna | Database Field | Typ | Opis |
|-------------|---------------|-----|------|
| `Nazwa` | `name` | VARCHAR(255) | Nazwa produktu |
| `Opis` | `description` | TEXT | Opis produktu |
| `Kategoria` | `category_id` | INT | ID kategorii (auto-create) |
| `Cena` | `price` | DECIMAL(10,2) | Cena |
| `Za ceną` | `price_unit` | VARCHAR(20) | Jednostka ceny |
| `Kod` | `code` | VARCHAR(50) | Unikalny kod |
| `Uwagi` | `notes` | TEXT | Dodatkowe uwagi |
| `Produkcja` | `production_site` | VARCHAR(100) | Miejsce produkcji |
| `Faktor` | `factor` | DECIMAL(10,3) | Współczynnik |
| `Jed. prod.` | `production_unit` | VARCHAR(20) | Jednostka produkcji |
| `Status` | `status` | VARCHAR(30) | active/notactive |

## Strategia Importu

### Opcja 1: Import tylko z Bazy Produktów
- Importuj wszystkie produkty z pliku `produkty-baza-produktów-*.csv`
- Użyj `Id` jako wartości `code` jeśli kod jest pusty
- Auto-twórz kategorie które nie istnieją

### Opcja 2: Import z obu plików (połączenie)
1. **Krok 1**: Wczytaj bazę produktów
2. **Krok 2**: Wczytaj produkty z zamówień
3. **Krok 3**: Połącz dane przez `Id`
4. **Krok 4**: Uzupełnij dane z obu źródeł:
   - Jeśli produkt istnieje tylko w bazie → użyj danych z bazy
   - Jeśli produkt istnieje w obu → połącz dane (priorytet: baza)
   - Dodatkowe dane z zamówień mogą uzupełnić brakujące pola

### Przykład Połączenia

```php
// Produkt ID: 1362
$baseData = [
    'id' => '1362',
    'name' => 'Deser Panna Cotta',
    'category' => 'Desery',
    'code' => '',
    'status' => 'active'
];

$ordersData = [
    'id' => '1362',
    'name' => 'Deser Panna Cotta',
    'quantity' => '15',  // Dodatkowa info - nie używana w products table
    'parent_entry_id' => '486779'
];

// Merge: base takes priority
$merged = array_merge($ordersData, $baseData);
// Use merged data to insert into products table
```

## Kategorie

System automatycznie utworzy kategorie które nie istnieją w bazie:

**Przykładowe kategorie z plików:**
- Ciasta
- Desery
- Ciasteczka
- Pączki
- Drożdżówki
- Torty Małe 1kg
- Torty Mini 0,5 Kg
- Torciki
- Ciastka
- Bułki
- Chleby
- Francuskie

## Uwagi Techniczne

### Enkodowanie
- Pliki używają UTF-8 z BOM
- Polskie znaki: ó, ł, ń, ć, ą, ę, ż, ź, ś
- System automatycznie obsługuje BOM przy wczytywaniu

### Puste Wartości
- Kod często pusty → system użyje `Id` jako fallback
- Cena może być pusta
- Opis często pusty

### Status
- `active` - produkt aktywny
- `notactive` - produkt nieaktywny

### Duplikaty
- Klucz unikalny: `code`
- Jeśli produkt z takim kodem istnieje → skip lub update
- Jeśli `code` pusty → użyj `Id` jako code

## Proces Podglądu (Preview)

System pokazuje:
1. ✅ **Mapowanie kolumn** - która kolumna CSV → pole w bazie
2. ✅ **Przykładowe dane** - pierwsze 10 wierszy z każdego pliku
3. ✅ **Dopasowanie** - przykładowy produkt który istnieje w obu plikach
4. ✅ **Statystyki** - ile produktów zostanie zaimportowanych
5. ✅ **Kategorie** - lista kategorii do utworzenia

Po akceptacji preview → rozpoczyna się import do bazy danych.
