# Migration Tool - Gravity Forms to New Cake Order System

## Overview
This migration tool imports cake orders from Gravity Forms CSV exports into the new cake ordering system.

## Features

### Automatic Data Mapping
- **Customer Data**: Creates or matches customers by phone number
- **Order Details**: Maps pickup date/time, location, payment method
- **Cake Specifications**: Maps flavors, sizes, types, and decorations
- **Extras**: Imports inscriptions, candles, wafers, cards, figurines

### Smart Matching
- Flavors are matched to existing database entries
- Sizes (Mały, Średni, Duży) auto-mapped
- Types (Standardowy, Okazjonalny, etc.) auto-matched
- Custom values preserved when no match found
- Pickup locations matched by name

### Duplicate Prevention
- Tracks Gravity Forms Entry ID to prevent re-importing
- Skips already imported orders

## Usage

### 1. Export Data from Gravity Forms
1. Go to Gravity Forms → Entries
2. Select cake orders form
3. Export to CSV with all fields

### 2. Import to New System
1. Navigate to: `/samanta_crm/migration`
2. Upload the CSV file
3. Click "Importuj Zamówienia"
4. Wait for completion (may take several minutes)

### 3. Review Results
- Success count shows imported orders
- Skipped count shows duplicates
- Error count shows failed imports
- Download error report for details

## Field Mapping

### Customer Fields
| CSV Field | Database Field |
|-----------|---------------|
| Dane zamawiającego (Imię) | customers.name (combined) |
| Dane zamawiającego (Nazwisko) | customers.name (combined) |
| Telefon | customers.phone |
| Email | customers.email |

### Order Fields
| CSV Field | Database Field |
|-----------|---------------|
| Data odbioru | orders.pickup_date |
| Godzina odbioru | orders.pickup_time |
| Odbiór | orders.pickup_location_id |
| Płatność | orders.payment_method |
| Wartość zaliczki | orders.deposit_amount |

### Cake Detail Fields
| CSV Field | Database Field |
|-----------|---------------|
| Smak | cake_order_details.flavor_id or flavor_custom |
| Wielkość | cake_order_details.size_id or size_custom |
| Standardowy/Okazjonalny/etc | cake_order_details.cake_type_ids |
| Napis | cake_order_details.has_inscription |
| Napis treść | cake_order_details.inscription_text |
| Świeczka | cake_order_details.has_candles |
| Ilość świeczek | cake_order_details.candles_count |
| Świeczka cyfry | cake_order_details.has_number_candle |
| Cyfra | cake_order_details.number_candle_value |
| Raca | cake_order_details.has_sparkler |
| Opłatek z własnym zdjęciem | cake_order_details.has_wafer_photo |
| Kartka bilecik | cake_order_details.has_card |
| Tekst na bileciku | cake_order_details.card_text |
| Wzór bileciku | cake_order_details.card_pattern |
| Figurka | cake_order_details.has_figurine |
| Inna figurka? | cake_order_details.figurine_description |
| Uwagi | cake_order_details.notes |

## Data Normalization

### Phone Numbers
- Removes spaces and formatting
- Adds +48 prefix for Polish numbers
- Example: `605068544` → `+48605068544`

### Dates
- Converts DD/MM/YYYY to YYYY-MM-DD
- Example: `29/11/2025` → `2025-11-29`

### Times
- Normalizes to HH:MM:SS format
- Example: `9:00` → `09:00:00`

### Custom Values
- When flavor is "Inny": Uses "Opisz inny smak tortu" field
- When size is "Inny": Uses "Dodatkowe informacje na temat rozmaru" field
- When type is "Inny": Uses "Opisz inny rodzaj tort" field

## Error Handling

### Common Errors
1. **Missing Phone Number**: Order skipped, customer required
2. **Invalid Date Format**: Check date format in CSV
3. **Missing Flavor**: Will save as custom flavor text
4. **Missing Location**: Order may be skipped

### Error Report
- Download CSV with error details
- Includes line number, error message, customer name
- Use to fix source data and re-import

## Performance

### Large Imports
- Processes 100-500 orders per minute (depends on server)
- Memory limit: Adjust PHP `memory_limit` if needed
- Timeout: Increase `max_execution_time` for large files

### Recommendations
- Import during off-peak hours
- Test with small sample first
- Keep browser window open during import
- Don't refresh page while processing

## Troubleshooting

### Import Fails
1. Check CSV file encoding (UTF-8 preferred)
2. Verify column headers match exactly
3. Check PHP error log for details
4. Increase PHP memory/timeout limits

### Duplicates Created
- System uses Gravity Forms ID to prevent duplicates
- If re-importing, duplicates are skipped automatically

### Missing Data
- Check field mapping in MigrationController.php
- Verify CSV export includes all fields
- Review error report for specific issues

## Technical Details

### Files
- `app/Controllers/MigrationController.php` - Import logic
- `app/Views/migration/index.php` - UI interface
- `public/index.php` - Routes configuration

### Database Tables
- `customers` - Customer records
- `orders` - Order headers
- `cake_order_details` - Cake specifications
- `cake_flavors` - Flavor lookup
- `cake_sizes` - Size lookup
- `cake_types` - Type lookup
- `pickup_locations` - Location lookup

### Dependencies
- CakeFlavor model
- CakeSize model
- CakeType model
- PickupLocation model
- Customer model
- Order model
- CakeOrderDetails model

## Notes

- Original Gravity Forms Entry IDs are preserved in order notes
- Customer matching is by phone number only
- Prices are not imported (set to 0, need manual review)
- File attachments (photos) are referenced but not copied
- All orders imported with status "pending"

## Support

For issues or questions:
1. Check error report first
2. Review this documentation
3. Contact system administrator
4. Check PHP error logs for technical details
