# Translation Keys Reference Guide

This document lists all standard translation keys used throughout the Samanta CRM application. Use these keys consistently across all views.

## Usage Pattern

```php
// Always provide default value as second parameter
<?= __('category.key', 'Default English Text') ?>
```

## Common Keys (common.*)

### General Actions
- `common.create` - "Create"
- `common.edit` - "Edit"
- `common.update` - "Update"
- `common.delete` - "Delete"
- `common.save` - "Save"
- `common.cancel` - "Cancel"
- `common.back` - "Back"
- `common.submit` - "Submit"
- `common.done` - "Done"
- `common.close` - "Close"
- `common.show` - "Show"
- `common.filter` - "Filter"
- `common.search` - "Search"
- `common.print` - "Print"

### Form Fields
- `common.name` - "Name"
- `common.email` - "Email"
- `common.password` - "Password"
- `common.confirm_password` - "Confirm Password"
- `common.status` - "Status"
- `common.type` - "Type"
- `common.code` - "Code"
- `common.description` - "Description"
- `common.notes` - "Notes"
- `common.date` - "Date"
- `common.from` - "From"
- `common.to` - "To"
- `common.quantity` - "Qty"
- `common.unit` - "Unit"
- `common.units` - "Units"

### Status & States
- `common.active` - "Active"
- `common.inactive` - "Inactive"
- `common.yes` - "Yes"
- `common.no` - "No"
- `common.all` - "All"
- `common.none` - "-- none --"
- `common.select` - "-- select --"
- `common.optional` - "(optional)"
- `common.not_specified` - "Not specified"
- `common.not_assigned` - "Not assigned"

### Entity References
- `common.customer` - "Customer"
- `common.role` - "Role"
- `common.created` - "Created"
- `common.created_at` - "Created"
- `common.actions` - "Actions"
- `common.search_products` - "Search products..."
- `common.cards` - "Cards"
- `common.list` - "List"
- `common.selected` - "Selected"
- `common.uncategorized` - "Uncategorized"

## Navigation Keys (nav.*)
- `nav.dashboard` - "Dashboard"
- `nav.users` - "Users"
- `nav.user_types` - "User Types"
- `nav.languages` - "Languages"
- `nav.admin` - "Admin"
- `nav.logout` - "Logout"

## Dashboard Keys (dashboard.*)
- `dashboard.total_users` - "Total Users"
- `dashboard.active_sessions` - "Active Sessions"
- `dashboard.pending_tasks` - "Pending Tasks"
- `dashboard.reports` - "Reports"
- `dashboard.recent_users` - "Recent Users"
- `dashboard.no_users_found` - "No users found."
- `dashboard.view_all_users` - "View All Users"
- `dashboard.system_info` - "System Info"
- `dashboard.php_version` - "PHP Version"
- `dashboard.environment` - "Environment"
- `dashboard.server_time` - "Server Time"
- `dashboard.quick_actions` - "Quick Actions"
- `dashboard.add_user` - "Add User"
- `dashboard.manage_users` - "Manage Users"
- `dashboard.products` - "Products"
- `dashboard.import_products` - "Import Products"
- `dashboard.categories` - "Categories"
- `dashboard.ingredients` - "Ingredients"
- `dashboard.units` - "Units"
- `dashboard.production_sites` - "Production Sites"
- `dashboard.report_flags` - "Report Flags"

## Orders Keys (orders.*)

### Page Titles
- `orders.orders` - "Orders"
- `orders.order` - "Order"
- `orders.order_number` - "Order #"
- `orders.new_order` - "New Order"
- `orders.edit_order` - "Edit Order"
- `orders.order_details` - "Order Details"
- `orders.order_items` - "Order Items"
- `orders.order_summary` - "Order Summary"
- `orders.items_summary` - "Items Summary"
- `orders.tablet_panel` - "Tablet Order"

### Form Fields
- `orders.order_date` - "Order Date"
- `orders.order_time` - "Order Time"
- `orders.delivery_date` - "Delivery Date"
- `orders.delivery` - "Delivery"
- `orders.order_type` - "Order Type"
- `orders.assigned_user` - "Assigned User"
- `orders.assigned` - "Assigned"
- `orders.assigned_to` - "Assigned To"
- `orders.verified` - "Verified"
- `orders.signature` - "Signature"
- `orders.signature_placeholder` - "Signature / Acknowledgement text"
- `orders.items` - "Items"
- `orders.total_items` - "Total Items"

### Order Types
- `orders.type_daily` - "Daily Order"
- `orders.type_additional` - "Additional Order"

### Status Values
- `orders.status_pending` - "Pending"
- `orders.status_processing` - "Processing"
- `orders.status_completed` - "Completed"
- `orders.status_cancelled` - "Cancelled"

### Actions & Messages
- `orders.select_products` - "Select Products"
- `orders.select_all_visible` - "Select Visible"
- `orders.clear_visible` - "Clear Visible"
- `orders.no_items` - "No items"
- `orders.no_orders_found` - "No orders found"
- `orders.empty_cart` - "No items added yet"
- `orders.add_items` - "Please add at least one item"
- `orders.submitting` - "Submitting order..."
- `orders.submit` - "Submit Order"
- `orders.confirm_delete` - "Delete order"
- `orders.verified_tooltip` - "Production manager verified; order will be processed"

## Products Keys (products.*)
- `products.products` - "Products"
- `products.create` - "Create Product"
- `products.edit` - "Edit Product"
- `products.show` - "View Product"
- `products.import` - "Import Products"
- `products.export` - "Export Products"
- `products.bulk_delete` - "Bulk Delete"
- `products.no_products_found` - "No products found"
- `products.product_code` - "Product Code"
- `products.price_unit` - "Price Unit"
- `products.production_unit` - "Production Unit"
- `products.category` - "Category"

## Customers Keys (customers.*)
- `customers.customers` - "Customers"
- `customers.create` - "Create Customer"
- `customers.edit` - "Edit Customer"
- `customers.receivers` - "Receivers"
- `customers.no_customers_found` - "No customers found"

## Categories Keys (categories.*)
- `categories.categories` - "Categories"
- `categories.create` - "Create Category"
- `categories.edit` - "Edit Category"
- `categories.no_categories_found` - "No categories found"

## Ingredients Keys (ingredients.*)
- `ingredients.ingredients` - "Ingredients"
- `ingredients.create` - "Create Ingredient"
- `ingredients.edit` - "Edit Ingredient"
- `ingredients.supplier` - "Supplier"
- `ingredients.no_ingredients_found` - "No ingredients found"

## Units Keys (units.*)
- `units.units` - "Units"
- `units.create` - "Create Unit"
- `units.edit` - "Edit Unit"
- `units.scope` - "Scope"
- `units.sort_order` - "Sort Order"

## Stock Keys (stock.*)
- `stock.ingredient_stock` - "Ingredient Stock"
- `stock.restocks` - "Restocks"
- `stock.usage_history` - "Usage History"
- `stock.usage_chart` - "Usage Chart"
- `stock.daily_usage` - "Daily Usage"
- `stock.current_stock` - "Current Stock"
- `stock.needed` - "Needed"
- `stock.applied` - "Applied"
- `stock.to_apply` - "To Apply"
- `stock.remaining_after` - "Remaining After"

## Reports Keys (reports.*)
- `reports.reports` - "Reports"
- `reports.daily` - "Daily Reports"
- `reports.report_flags` - "Report Flags"
- `reports.generate` - "Generate Report"
- `reports.export` - "Export Report"

## Production Keys (production.*)
- `production.production_sites` - "Production Sites"
- `production.create_site` - "Create Production Site"
- `production.edit_site` - "Edit Production Site"

## Users Keys (users.*)
- `users.users` - "Users"
- `users.create_user` - "Create User"
- `users.edit_user` - "Edit User"
- `users.user_types` - "User Types"
- `users.no_users_found` - "No users found"

## Settings Keys (settings.*)
- `settings.settings` - "Settings"
- `settings.general` - "General Settings"
- `settings.site_name` - "Site Name"
- `settings.site_logo` - "Site Logo"
- `settings.show_site_name_with_logo` - "Show Site Name with Logo"

## App Keys (app.*)
- `app.name` - "Samanta CRM"
- `app.welcome` - "Welcome"
- `app.copyright` - "All rights reserved"

## Implementation Guidelines

### 1. Always Use Defaults
```php
// ✅ Good
<?= __('orders.order_date', 'Order Date') ?>

// ❌ Bad - Missing default
<?= __('orders.order_date') ?>
```

### 2. Consistent Key Naming
- Use lowercase with underscores
- Group by category (prefix)
- Be descriptive: `orders.order_date` not `orders.date`

### 3. Common Patterns
```php
// Page titles
<?php $title = __('orders.orders', 'Orders'); ?>

// Form labels
<label><?= __('common.customer', 'Customer') ?></label>

// Buttons
<button><?= __('common.save', 'Save') ?></button>

// Status badges
<span><?= __('orders.status_pending', 'Pending') ?></span>

// Empty states
<p><?= __('orders.no_orders_found', 'No orders found') ?></p>
```

### 4. Placeholders & Tooltips
```php
// Input placeholders
<input placeholder="<?= __('common.search_products', 'Search products...') ?>">

// Tooltips
<button title="<?= __('common.edit', 'Edit') ?>">
```

### 5. JavaScript Strings
```php
// In JavaScript sections
showNotification('<?= __('orders.submitting', 'Submitting order...') ?>', 'info');
confirm('<?= __('orders.confirm_delete', 'Delete order') ?> #<?=$id?>?');
```

## Adding New Keys

When adding new translatable text:

1. Check this reference first - key might already exist
2. Follow the naming convention: `category.specific_name`
3. Add to this document for future reference
4. Use descriptive defaults in English
5. The system will auto-create the key in the database on first use

## Translation Management

To manage translations:
1. Visit `/samanta_crm/languages` in admin panel
2. All auto-created keys will appear there
3. Refine translations as needed
4. Export/import for bulk updates

---

**Last Updated:** November 27, 2025  
**Version:** 1.0  
**Auto-Creation:** Enabled by default
