<?php
require_once __DIR__ . '/bootstrap/db.php';

echo "=== Checking Menu Categories System ===\n\n";

// Check if menu_categories table exists
$result = $pdo->query("SHOW TABLES LIKE 'menu_categories'")->fetch();
if ($result) {
    echo "✓ menu_categories table EXISTS\n";
    
    // Count categories
    $count = $pdo->query("SELECT COUNT(*) FROM menu_categories")->fetchColumn();
    echo "  Total categories: $count\n\n";
    
    // Show first 5
    echo "  First 5 categories:\n";
    $cats = $pdo->query("SELECT id, name, sort_order FROM menu_categories ORDER BY sort_order LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($cats as $cat) {
        echo "    - [{$cat['id']}] {$cat['name']} (order: {$cat['sort_order']})\n";
    }
} else {
    echo "✗ menu_categories table NOT FOUND\n";
}

echo "\n=== Checking menu_items table ===\n\n";

// Check menu_items columns
$cols = $pdo->query("SHOW COLUMNS FROM menu_items")->fetchAll(PDO::FETCH_ASSOC);
echo "Columns:\n";
foreach ($cols as $col) {
    if (strpos($col['Field'], 'category') !== false) {
        echo "  - {$col['Field']} ({$col['Type']})\n";
    }
}

echo "\n✅ Done!\n";
