<?php
/**
 * URL Helper Functions
 */

/**
 * Get the base path for URLs
 * @return string Base path
 */
function getBasePath() {
    // Both development and production use /samanta_crm
    // Root .htaccess handles routing to /public/ automatically
    return '/samanta_crm';
}

/**
 * Generate a URL for the application
 * @param string $path Path without leading slash (e.g., 'dashboard', 'users/create')
 * @return string Full URL
 */
function url($path = '') {
    $base = getBasePath();
    $path = ltrim($path, '/');
    return $path ? $base . '/' . $path : $base;
}

/**
 * Generate an asset URL
 * @param string $path Asset path (e.g., 'css/app.css')
 * @return string Full asset URL
 */
function asset($path) {
    // Assets are accessed via /samanta_crm/public/assets/
    return '/samanta_crm/public/assets/' . ltrim($path, '/');
}

/**
 * Redirect to a URL
 * @param string $path Path to redirect to
 */
function redirect($path) {
    header('Location: ' . url($path));
    exit;
}

