<!-- Clock Widget - Reusable analog and digital clock -->
<div class="">
    <div class="card-body text-center d-flex flex-row align-items-center justify-content-center">
        <!-- Analog Clock -->
        <div class="analog-clock mx-3 bg-primary" style="width: 50px; height: 50px; position: relative; border: 4px solid rgba(255,255,255,0.3); border-radius: 50%; background: rgb(92 92 92 / 25%);">
            <div class="clock-hour-hand" style="position: absolute; width: 3.33%; height: 29.17%; background: white; top: 20.83%; left: 48.33%; transform-origin: 50% 100%; border-radius: 2px;"></div>
            <div class="clock-minute-hand" style="position: absolute; width: 2.5%; height: 37.5%; background: white; top: 12.5%; left: 48.75%; transform-origin: 50% 100%; border-radius: 2px;"></div>
            <div class="clock-second-hand" style="position: absolute; width: 1.67%; height: 41.67%; background: #ffc107; top: 8.33%; left: 49.17%; transform-origin: 50% 100%; border-radius: 2px; transition: transform 0.05s cubic-bezier(0.4, 0.2, 0.2, 1);"></div>
            <div style="position: absolute; width: 8.33%; height: 8.33%; background: white; border-radius: 50%; top: 45.83%; left: 45.83%;"></div>
        </div>
        <div class="digital-clock">
            <!-- Digital Time -->
            <h3 class="clock-digital-time accordion bg-gradient bg-primary digital-clock-digits mb-1 rounded-pill " style="font-size: 1.75rem; color: var(--bs-dark-bg-subtle)">--:--:--</h3>
            
            <!-- Date -->
            <p class="clock-digital-date mb-0 fw-bold" style="font-size: 0.9rem;">---</p>
        </div>
    </div>
</div>

<script>
// Initialize clock widget
(function() {
    // Find all clock widgets on the page
    const clockWidgets = document.querySelectorAll('.analog-clock');
    
    if (clockWidgets.length === 0) return;
    
    function updateAllClocks() {
        const now = new Date();
        
        // Calculate angles
        const hours = now.getHours() % 12;
        const minutes = now.getMinutes();
        const seconds = now.getSeconds();
        const milliseconds = now.getMilliseconds();
        
        const hourDeg = (hours * 30) + (minutes * 0.5);
        const minuteDeg = minutes * 6;
        const secondDeg = (seconds * 6) + (milliseconds * 0.006); // Smooth second hand
        
        // Update all clock instances
        clockWidgets.forEach(widget => {
            const hourHand = widget.querySelector('.clock-hour-hand');
            const minuteHand = widget.querySelector('.clock-minute-hand');
            const secondHand = widget.querySelector('.clock-second-hand');
            
            if (hourHand) hourHand.style.transform = `rotate(${hourDeg}deg)`;
            if (minuteHand) minuteHand.style.transform = `rotate(${minuteDeg}deg)`;
            if (secondHand) secondHand.style.transform = `rotate(${secondDeg}deg)`;
        });
        
        // Update digital time displays
        const timeStr = now.toLocaleTimeString('pl-PL', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
        document.querySelectorAll('.clock-digital-time').forEach(el => {
            el.textContent = timeStr;
        });
        
        // Update date displays
        const dateStr = now.toLocaleDateString('pl-PL', { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' });
        const capitalizedDate = dateStr.charAt(0).toUpperCase() + dateStr.slice(1);
        document.querySelectorAll('.clock-digital-date').forEach(el => {
            el.textContent = capitalizedDate;
        });
    }
    
    // Update immediately and then every 50ms for smooth movement
    updateAllClocks();
    setInterval(updateAllClocks, 50);
    
    // Expose global clock API
    window.ClockWidget = {
        update: updateAllClocks,
        init: function() {
            updateAllClocks();
        }
    };
})();
</script>


