<?php 
$title = __('user_types.title', 'User Types');
ob_start(); 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-tags"></i> <?= __('user_types.management', 'User Types Management') ?>
    </h1>
    <a href="/samanta_crm/user-types/create" class="btn btn-primary">
        <i class="fas fa-plus"></i> <?= __('user_types.add', 'Add User Type') ?>
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if (empty($userTypes)): ?>
            <div class="text-center py-4">
                <i class="fas fa-tags fa-3x text-muted mb-3"></i>
                <h5><?= __('user_types.no_types', 'No user types found') ?></h5>
                <p class="text-muted"><?= __('user_types.get_started', 'Get started by adding your first user type.') ?></p>
                <a href="/samanta_crm/user-types/create" class="btn btn-primary">
                    <i class="fas fa-plus"></i> <?= __('user_types.add', 'Add User Type') ?>
                </a>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover" id="userTypesTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th><?= __("common.name", "Name") ?></th>
                            <th><?= __("common.description", "Description") ?></th>
                            <th><?= __("common.color", "Color") ?></th>
                            <th><?= __("common.status", "Status") ?></th>
                            <th><?= __("user_types.permissions", "Permissions") ?></th>
                            <th><?= __("common.created_at", "Created") ?></th>
                            <th><?= __("common.actions", "Actions") ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($userTypes as $userType): ?>
                        <tr>
                            <td><?= $userType['id'] ?></td>
                            <td>
                                <span class="badge" style="background-color: <?= htmlspecialchars($userType['color']) ?>;">
                                    <?= htmlspecialchars($userType['name']) ?>
                                </span>
                            </td>
                            <td><?= htmlspecialchars($userType['description']) ?: '-' ?></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="color-preview me-2" style="width: 20px; height: 20px; background-color: <?= htmlspecialchars($userType['color']) ?>; border-radius: 3px;"></div>
                                    <small><?= htmlspecialchars($userType['color']) ?></small>
                                </div>
                            </td>
                            <td>
                                <?php if ($userType['is_active']): ?>
                                    <span class="badge bg-success"><?= __("common.active", "Active") ?></span>
                                <?php else: ?>
                                    <span class="badge bg-secondary"><?= __("common.inactive", "Inactive") ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php 
                                $permissions = $userType['permissions'] ?? [];
                                
                                // Handle both string and array cases with better validation
                                if (is_string($permissions)) {
                                    $permissions = json_decode($permissions, true) ?: [];
                                } elseif (!is_array($permissions)) {
                                    $permissions = [];
                                }
                                
                                // Count only permissions that are explicitly set to true
                                $truePermissionCount = 0;
                                if (is_array($permissions)) {
                                    foreach ($permissions as $key => $value) {
                                        if ($value === true) {
                                            $truePermissionCount++;
                                        }
                                    }
                                }
                                
                                if ($truePermissionCount > 0): 
                                ?>
                                    <span class="badge bg-info">
                                        <?= $truePermissionCount ?> <?= __('user_types.permissions_count', 'permission(s)') ?>
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-secondary"><?= __('user_types.no_permissions', 'No permissions') ?></span>
                                <?php endif; ?>
                            </td>
                            <td><?= date('M j, Y g:i A', strtotime($userType['created_at'])) ?></td>
                            <td>
                                <div class="btn-group btn-group-sm" role="group">
                                    <a href="/samanta_crm/user-types/<?= $userType['id'] ?>/edit" class="btn btn-outline-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-outline-danger" onclick="deleteUserType(<?= $userType['id'] ?>, '<?= htmlspecialchars($userType['name']) ?>')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?= __('common.confirm_delete', 'Confirm Delete') ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p><?= __('user_types.confirm_delete_msg', 'Are you sure you want to delete user type') ?> <strong id="deleteUserTypeName"></strong>?</p>
                <p class="text-muted"><?= __('user_types.delete_warning', 'This action cannot be undone and will fail if users are assigned to this type.') ?></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?= __("common.cancel", "Cancel") ?></button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    <button type="submit" class="btn btn-danger"><?= __("common.delete", "Delete") ?></button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php 
$content = ob_get_clean();
$scripts = '
<script>
function deleteUserType(id, name) {
    document.getElementById("deleteUserTypeName").textContent = name;
    document.getElementById("deleteForm").action = "/samanta_crm/user-types/" + id + "/delete";
    new bootstrap.Modal(document.getElementById("deleteModal")).show();
}
</script>
';
include '../app/Views/layout.php'; 
?>


