<?php 
$title = __('user_types.create', 'Create User Type');

// Helper function for category icons
function getCategoryIcon($category) {
    $icons = [
        'Users' => 'users',
        'User_types' => 'user-tag', 
        'Languages' => 'globe',
        'Translations' => 'language',
        'Dashboard' => 'tachometer-alt',
        'System' => 'cogs',
        'Reports' => 'chart-bar',
        'Auth' => 'lock'
    ];
    
    return $icons[$category] ?? 'tags';
}

ob_start(); 
?>

<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-plus"></i> <?= __('user_types.create_new', 'Create New User Type') ?>
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="/samanta_crm/user-types" id="createUserTypeForm">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label"><?= __('common.name', 'Name') ?> *</label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="color" class="form-label"><?= __('common.color', 'Color') ?></label>
                                <input type="color" class="form-control form-control-color" id="color" name="color" value="#007bff">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="description" class="form-label"><?= __('common.description', 'Description') ?></label>
                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                            <label class="form-check-label" for="is_active">
                                <?= __('common.active', 'Active') ?>
                            </label>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h6 class="mb-3"><i class="fas fa-shield-alt"></i> <?= __('user_types.permissions', 'Permissions') ?></h6>
                    
                    <div class="row">
                        <?php foreach ($permissions as $category => $categoryPermissions): ?>
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header py-2">
                                    <h6 class="mb-0">
                                        <i class="fas fa-<?= getCategoryIcon($category) ?>"></i>
                                        <?= htmlspecialchars($category) ?>
                                        <small class="text-muted">(<?= count($categoryPermissions) ?>)</small>
                                    </h6>
                                </div>
                                <div class="card-body py-2">
                                    <?php foreach ($categoryPermissions as $permission): ?>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" 
                                               id="perm_<?= htmlspecialchars($permission['key']) ?>" 
                                               name="permissions[<?= htmlspecialchars($permission['key']) ?>]" 
                                               value="1">
                                        <label class="form-check-label" for="perm_<?= htmlspecialchars($permission['key']) ?>">
                                            <strong><?= htmlspecialchars($permission['name']) ?></strong>
                                            <?php if (!empty($permission['description'])): ?>
                                            <br><small class="text-muted"><?= htmlspecialchars($permission['description']) ?></small>
                                            <?php endif; ?>
                                        </label>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <a href="/samanta_crm/user-types" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> <?= __('common.back', 'Back') ?>
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> <?= __('user_types.create_btn', 'Create User Type') ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php 
$content = ob_get_clean();
$scripts = '
<script>
// Select all permissions in a group
document.querySelectorAll(".card-header").forEach(header => {
    header.style.cursor = "pointer";
    header.addEventListener("click", function() {
        const card = this.closest(".card");
        const checkboxes = card.querySelectorAll("input[type=checkbox]");
        const allChecked = Array.from(checkboxes).every(cb => cb.checked);
        
        checkboxes.forEach(cb => {
            cb.checked = !allChecked;
        });
    });
});
</script>
';
include '../app/Views/layout.php'; 
?>


