<?php $title=__('units.title', 'Units'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h3 mb-0">
    <i class="fas fa-ruler"></i> <?= __('units.title', 'Units') ?>
  </h1>
  <div class="btn-group">
    <a href="/samanta_crm/units/create" class="btn btn-primary">
      <i class="fas fa-plus"></i> <?= __('common.add', 'Add') ?>
    </a>
  </div>
</div>

<div class="card">
  <div class="card-header py-2">
    <span class="small fw-bold">
      <i class="fas fa-table me-1"></i><?= __('units.title', 'Units') ?>
    </span>
  </div>
  <div class="card-body pt-0">
    <div class="table-responsive">
      <table class="table table-sm table-hover align-middle data-table mb-0" id="unitsTable">
        <thead class="table-light">
          <tr>
            <th><?= __('units.code', 'Code') ?></th>
            <th><?= __("common.name", "Name") ?></th>
            <th class="d-none d-md-table-cell"><?= __('units.scope', 'Scope') ?></th>
            <th class="d-none d-lg-table-cell"><?= __('units.conversion', 'Conversion') ?></th>
            <th class="d-none d-xl-table-cell"><?= __('common.order', 'Order') ?></th>
            <th class="d-none d-lg-table-cell"><?= __("common.active", "Active") ?></th>
            <th class="text-end"></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($units as $u): ?>
          <tr>
            <td><code class="small"><?= htmlspecialchars($u['code']) ?></code></td>
            <td>
              <strong class="small"><?= htmlspecialchars($u['name']) ?></strong>
              <!-- Mobile info -->
              <div class="d-md-none small text-muted mt-1">
                <?php 
                $scopeClass = $u['scope']=='both' ? 'bg-primary' : ($u['scope']=='ingredient' ? 'bg-success' : 'bg-info');
                ?>
                <span class="badge <?= $scopeClass ?> me-1"><?= htmlspecialchars($u['scope']??'product') ?></span>
                <?php if($u['is_active']): ?>
                  <span class="badge bg-success"><?= __('common.yes','Yes') ?></span>
                <?php else: ?>
                  <span class="badge bg-secondary"><?= __('common.no','No') ?></span>
                <?php endif; ?>
              </div>
              <!-- Conversion info on tablets -->
              <?php if(!empty($u['base_unit']) && !empty($u['conversion_factor'])): ?>
                <div class="d-lg-none small text-muted mt-1">
                  <i class="fas fa-exchange-alt me-1"></i>
                  1 <?= htmlspecialchars($u['code']) ?> = <?= $u['conversion_factor'] ?> <?= htmlspecialchars($u['base_unit_code'] ?? '') ?>
                </div>
              <?php endif; ?>
            </td>
            <td class="d-none d-md-table-cell">
              <?php 
              $scopeClass = $u['scope']=='both' ? 'bg-primary' : ($u['scope']=='ingredient' ? 'bg-success' : 'bg-info');
              ?>
              <span class="badge <?= $scopeClass ?>"><?= htmlspecialchars($u['scope']??'product') ?></span>
            </td>
            <td class="d-none d-lg-table-cell">
              <?php if(!empty($u['base_unit']) && !empty($u['conversion_factor'])): ?>
                <span class="badge bg-info-subtle text-info-emphasis">
                  <i class="fas fa-exchange-alt me-1"></i>
                  1 <?= htmlspecialchars($u['code']) ?> = <?= $u['conversion_factor'] ?> <?= htmlspecialchars($u['base_unit_code'] ?? '') ?>
                </span>
              <?php else: ?>
                <span class="text-muted small"><i class="fas fa-minus"></i></span>
              <?php endif; ?>
            </td>
            <td class="d-none d-xl-table-cell"><?= (int)$u['sort_order'] ?></td>
            <td class="d-none d-lg-table-cell">
              <?php if($u['is_active']): ?>
                <span class="badge bg-success"><?= __('common.yes','Yes') ?></span>
              <?php else: ?>
                <span class="badge bg-secondary"><?= __('common.no','No') ?></span>
              <?php endif; ?>
            </td>
            <td class="text-end">
              <div class="btn-group btn-group-sm">
                <a class="btn btn-outline-primary" href="/samanta_crm/units/<?= $u['id'] ?>/edit" title="<?= __('common.edit', 'Edit') ?>">
                  <i class="fas fa-edit"></i>
                </a>
                <form method="POST" action="/samanta_crm/units/<?= $u['id'] ?>/delete" class="d-inline d-none d-sm-inline-block" onsubmit="return confirm('<?= __('common.confirm_delete', 'Delete?') ?>')">
                  <button class="btn btn-outline-danger" title="<?= __('common.delete', 'Delete') ?>">
                    <i class="fas fa-trash"></i>
                  </button>
                </form>
              </div>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
  <div class="card-footer py-2">
    <div class="small text-muted">
      <?= __('common.total', 'Total') ?>: <?= count($units) ?> <?= __('common.items', 'items') ?>
    </div>
  </div>
</div>

<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>


