<?php $title=__('units.edit', 'Edit Unit'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h3 mb-0">
    <i class="fas fa-ruler"></i> <?= __('units.edit', 'Edit Unit') ?>
  </h1>
  <div class="btn-group">
    <a href="/samanta_crm/units" class="btn btn-secondary">
      <i class="fas fa-arrow-left"></i> <?= __('common.back', 'Back') ?>
    </a>
  </div>
</div>

<div class="card">
  <div class="card-header py-2">
    <span class="small fw-bold">
      <i class="fas fa-edit me-1"></i><?= __('units.unit_info', 'Unit Information') ?>
    </span>
  </div>
  <div class="card-body py-3">
    <form method="POST" action="/samanta_crm/units/<?= $unit['id'] ?>/update" id="unitForm">
      <div class="mb-3">
        <label class="form-label"><?= __('units.code', 'Code') ?> *</label>
        <input name="code" value="<?= htmlspecialchars($unit['code']) ?>" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label"><?= __('common.name', 'Name') ?> *</label>
        <input name="name" value="<?= htmlspecialchars($unit['name']) ?>" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label"><?= __('units.scope', 'Scope') ?></label>
        <select name="scope" class="form-select">
          <?php $scopes=['product'=>__('units.scope_product','Product'),'ingredient'=>__('units.scope_ingredient','Ingredient'),'both'=>__('units.scope_both','Both')]; foreach($scopes as $k=>$label): ?>
            <option value="<?= $k ?>" <?= ($unit['scope']??'product')===$k?'selected':''; ?>><?= $label ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label"><?= __('common.sort_order', 'Sort Order') ?></label>
        <input type="number" name="sort_order" value="<?= htmlspecialchars($unit['sort_order']) ?>" class="form-control">
      </div>
      
      <hr class="my-4">
      <h6 class="mb-3">
        <i class="fas fa-exchange-alt me-2"></i><?= __('units.conversion_settings', 'Conversion Settings') ?>
      </h6>
      <div class="alert alert-info small mb-3">
        <i class="fas fa-info-circle me-1"></i>
        <?= __('units.conversion_help', 'Set up automatic conversion between units (e.g., 1g = 0.001kg). Leave empty if this is a base unit.') ?>
      </div>
      
      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label"><?= __('units.base_unit', 'Base Unit') ?></label>
          <select name="base_unit" class="form-select" id="baseUnitSelect">
            <option value=""><?= __('units.no_conversion', '-- No Conversion (Base Unit) --') ?></option>
            <?php foreach($allUnits as $bu): ?>
              <?php if($bu['id'] != $unit['id']): ?>
                <option value="<?= $bu['id'] ?>" <?= ($unit['base_unit']??'')==$bu['id']?'selected':'' ?>>
                  <?= htmlspecialchars($bu['code']) ?> - <?= htmlspecialchars($bu['name']) ?>
                </option>
              <?php endif; ?>
            <?php endforeach; ?>
          </select>
          <div class="form-text"><?= __('units.base_unit_help', 'The unit to convert to (e.g., kg for grams)') ?></div>
        </div>
        
        <div class="col-md-6 mb-3">
          <label class="form-label"><?= __('units.conversion_factor', 'Conversion Factor') ?></label>
          <input type="number" name="conversion_factor" value="<?= htmlspecialchars($unit['conversion_factor']??'') ?>" class="form-control" step="0.0000000001" placeholder="0.001">
          <div class="form-text"><?= __('units.conversion_factor_help', 'Multiply by this to get base unit (e.g., 0.001 for g→kg)') ?></div>
        </div>
      </div>
      
      <div class="mb-3">
        <div class="card bg-light">
          <div class="card-body py-2">
            <small class="text-muted">
              <strong><?= __('units.example', 'Example') ?>:</strong> 
              <?= __('units.conversion_example', 'To convert grams to kilograms: base_unit=kg, conversion_factor=0.001 (because 1g × 0.001 = 0.001kg)') ?>
            </small>
          </div>
        </div>
      </div>
      
      <hr class="my-4">
      
      <div class="form-check mb-3">
        <input type="checkbox" class="form-check-input" id="u_active" name="is_active" <?= $unit['is_active']?'checked':'' ?>>
        <label for="u_active" class="form-check-label"><?= __("common.active", "Active") ?></label>
      </div>
    </form>
  </div>
  <div class="card-footer py-2 d-flex gap-2">
    <button type="submit" form="unitForm" class="btn btn-primary">
      <i class="fas fa-save"></i> <?= __("common.update", "Update") ?>
    </button>
    <a class="btn btn-secondary" href="/samanta_crm/units">
      <i class="fas fa-times"></i> <?= __("common.cancel", "Cancel") ?>
    </a>
  </div>
</div>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


