<?php $title=__('units.create', 'Add Unit'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h3 mb-0">
    <i class="fas fa-ruler"></i> <?= __('units.create', 'Add Unit') ?>
  </h1>
  <div class="btn-group">
    <a href="/samanta_crm/units" class="btn btn-secondary">
      <i class="fas fa-arrow-left"></i> <?= __('common.back', 'Back') ?>
    </a>
  </div>
</div>

<div class="card">
  <div class="card-header py-2">
    <span class="small fw-bold">
      <i class="fas fa-plus me-1"></i><?= __('units.unit_info', 'Unit Information') ?>
    </span>
  </div>
  <div class="card-body py-3">
    <form method="POST" action="/samanta_crm/units" id="unitForm">
      <div class="mb-3">
        <label class="form-label"><?= __('units.code', 'Code') ?> *</label>
        <input name="code" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label"><?= __('common.name', 'Name') ?> *</label>
        <input name="name" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label"><?= __('units.scope', 'Scope') ?></label>
        <select name="scope" class="form-select">
          <option value="product"><?= __('units.scope_product', 'Product') ?></option>
          <option value="ingredient"><?= __('units.scope_ingredient', 'Ingredient') ?></option>
          <option value="both"><?= __('units.scope_both', 'Both') ?></option>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label"><?= __('common.sort_order', 'Sort Order') ?></label>
        <input type="number" name="sort_order" value="0" class="form-control">
      </div>
      <div class="form-check mb-3">
        <input type="checkbox" class="form-check-input" id="u_active" name="is_active" checked>
        <label for="u_active" class="form-check-label"><?= __("common.active", "Active") ?></label>
      </div>

      <hr class="my-4">

      <h6 class="mb-3">
        <i class="fas fa-exchange-alt me-1"></i> <?= __('units.conversion_settings', 'Conversion Settings') ?>
      </h6>

      <div class="alert alert-info small mb-3">
        <i class="fas fa-info-circle me-1"></i>
        <?= __('units.conversion_help', 'If this unit can be converted to another (e.g., grams to kilograms), select the base unit and enter the conversion factor.') ?>
      </div>

      <div class="row mb-3">
        <div class="col-md-6">
          <label class="form-label"><?= __('units.base_unit', 'Base Unit') ?></label>
          <select name="base_unit" class="form-select">
            <option value=""><?= __('common.none', 'None') ?></option>
            <?php foreach($allUnits as $u): ?>
              <option value="<?= $u['id'] ?>"><?= $u['name'] ?> (<?= $u['code'] ?>)</option>
            <?php endforeach; ?>
          </select>
          <div class="form-text"><?= __('units.base_unit_help', 'The unit to convert to') ?></div>
        </div>
        <div class="col-md-6">
          <label class="form-label"><?= __('units.conversion_factor', 'Conversion Factor') ?></label>
          <input type="number" name="conversion_factor" step="0.0000000001" class="form-control" placeholder="0.001">
          <div class="form-text"><?= __('units.conversion_factor_help', 'Multiply by this to convert') ?></div>
        </div>
      </div>

      <div class="card bg-light border-0 mb-3">
        <div class="card-body py-2 small">
          <strong><?= __('common.example', 'Example') ?>:</strong>
          <?= __('units.conversion_example', 'For grams to kilograms: Base Unit = kg, Factor = 0.001 (because 1g × 0.001 = 0.001kg)') ?>
        </div>
      </div>
    </form>
  </div>
  <div class="card-footer py-2 d-flex gap-2">
    <button type="submit" form="unitForm" class="btn btn-primary">
      <i class="fas fa-save"></i> <?= __("common.save", "Save") ?>
    </button>
    <a class="btn btn-secondary" href="/samanta_crm/units">
      <i class="fas fa-times"></i> <?= __("common.cancel", "Cancel") ?>
    </a>
  </div>
</div>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


