<?php $title=__('stock.usage_detail', 'Usage History Detail'); ob_start(); ?>

<?php if(isset($_SESSION['success'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <?=htmlspecialchars($_SESSION['success']); unset($_SESSION['success']);?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-calendar-alt"></i> <?= __('stock.usage_detail_for', 'Usage Detail') ?>: <strong><?=htmlspecialchars($date);?></strong>
    </h1>
    <div class="btn-group">
        <form method="post" action="/samanta_crm/stock/rollback-daily" class="d-inline" onsubmit="return confirm('<?= __('stock.rollback_confirm', 'Rollback all usage for') ?> <?=$date?>? <?= __('stock.rollback_restore', 'This will restore stock.') ?>')">
            <input type="hidden" name="rollback_date" value="<?=htmlspecialchars($date);?>">
            <button class="btn btn-warning">
                <i class="fas fa-undo me-1"></i><?= __('stock.rollback_date', 'Rollback This Date') ?>
            </button>
        </form>
        <a href="/samanta_crm/stock/usage-history" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('stock.back_to_dates', 'Back to Dates') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('stock.usage_details', 'Usage Details') ?></span>
    </div>
    <div class="card-body pt-0">
        <table class="table table-sm table-hover align-middle data-table mb-0">
	<thead><tr><th>Ingredient</th><th class="text-end">Applied Qty</th><th>Unit</th><th><?= __("common.status", "Status") ?></th></tr></thead>
	<tbody>
	<?php foreach($rows as $r): ?>
		<tr>
			<td><?=htmlspecialchars($r['name']);?></td>
			<td class="text-end"><?= (int)round($r['applied_qty']); ?></td>
			<td><?= htmlspecialchars($r['unit'] ?? '') ?></td>
			<td><?=$r['rolled_back']?'<span class="badge bg-secondary">Rolled Back</span>':'<span class="badge bg-success">Applied</span>';?></td>
		</tr>
	<?php endforeach; ?>
        </tbody>
        </table>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span></span>
        <div class="small text-muted">
            <?= __('common.total', 'Total') ?>: <?= count($rows) ?> <?= __('common.items', 'items') ?>
        </div>
    </div>
</div>

<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


