<?php $title='Ingredient Usage Chart'; ob_start(); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
	<h1 class="h3 mb-0">
		<i class="fas fa-chart-line"></i> <?= __('stock.usage_chart', 'Usage Chart') ?>
	</h1>
	<a href="/samanta_crm/stock/ingredients" class="btn btn-sm btn-secondary">
		<i class="fas fa-arrow-left me-1"></i><span class="d-none d-sm-inline"><?= __('common.back', 'Back') ?></span>
	</a>
</div>
<div class="card mb-3 bg-warning-subtle">
	<div class="card-body">
		<form class="row g-2 align-items-end mb-3" method="get">
			
			<div class="col-6 col-md-3">
				<label class="form-label small mb-1"><?= __('common.start_date', 'Start') ?></label>
				<input type="date" name="start_date" class="form-control" value="<?=htmlspecialchars($start_date??'');?>">
			</div>
			<div class="col-6 col-md-3">
				<label class="form-label small mb-1"><?= __('common.end_date', 'End') ?></label>
				<input type="date" name="end_date" class="form-control" value="<?=htmlspecialchars($end_date??'');?>">
			</div>
			<div class="col-12 col-md-4">
				<label class="form-label small mb-1"><?= __('stock.ingredient', 'Ingredient') ?></label>
				<select name="ingredient_id" class="form-select">
					<option value="0"><?= __("common.all", "All") ?></option>
					<?php foreach(($ingredients??[]) as $ing): ?>
						<option value="<?=$ing['id'];?>" <?= (int)($ingredient_id??0)==(int)$ing['id']?'selected':''; ?>><?=htmlspecialchars($ing['name']);?></option>
					<?php endforeach; ?>
				</select>
			</div>
			<div class="col-6 col-md-1">
				<button class="btn btn-primary w-100"><i class="fas fa-sync"></i><span class="d-none d-lg-inline ms-1"><?= __("common.update", "Update") ?></span></button>
			</div>
			<div class="col-6 col-md-1">
				<a href="/samanta_crm/stock/usage-chart" class="btn btn-outline-secondary w-100"><i class="fas fa-redo"></i><span class="d-none d-lg-inline ms-1"><?= __("common.reset", "Reset") ?></span></a>
			</div>
		</form>
	</div>
</div>
<div class="mb-3 small text-muted">
	<i class="fas fa-info-circle me-1"></i><?= __('stock.chart_help', 'Lines: Applied Usage & Stock. Bars: Restocks. Filter to a single ingredient for detailed lines.') ?>
</div>
<div class="card">
	<div class="card-body">
		<div class="position-relative" style="height:400px; min-height:300px;">
			<canvas id="usageChart" style="height:100%; width:100%;"></canvas>
		</div>
	</div>
</div>
<?php $content=ob_get_clean(); ob_start(); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
const labels = <?=isset($dates)?json_encode($dates):'[]';?>;
const raw = <?=isset($datasets)?json_encode($datasets):'[]';?>;
function palette(i){ const c=['#0d6efd','#198754','#dc3545','#ff6f00','#20c997','#6f42c1','#fd7e14','#6610f2','#0dcaf0','#1982c4','#8ac926','#ffca3a','#ff595e']; return c[i%c.length]; }
if(labels.length && raw.length){
	const finalDs = [];
	raw.forEach((ds,i)=>{
		const baseColor = palette(i);
		const isStock = ds.series==='stock';
		const isRestock = ds.series==='restock';
		finalDs.push({
			type: ds.type || (isRestock? 'bar':'line'),
			label: ds.label,
			data: ds.data,
			borderColor: baseColor,
			backgroundColor: isRestock? baseColor+'77' : baseColor+'33',
			fill:false,
			tension: isRestock? 0 : 0.15,
			borderDash: isStock? [6,4]:[],
			pointRadius: isRestock? 0:1.5,
			spanGaps:true,
			yAxisID: 'y',
			order: isRestock? 0:1
		});
	});
		const ctx=document.getElementById('usageChart').getContext('2d');
		new Chart(ctx,{
			type:'line',
			data:{ labels:labels, datasets:finalDs },
			options:{
				responsive:true,
				maintainAspectRatio:false,
				aspectRatio: labels.length>0? Math.min(3, Math.max(1.4, ctx.canvas.parentElement.clientWidth/420)) : 2,
				interaction:{mode:'index', intersect:false},
				resizeDelay:50,
				plugins:{ legend:{ position:'bottom'} },
				scales:{ y:{ beginAtZero:true } }
			}
		});
}
	// Hard guard to prevent runaway height if Chart.js miscalculates
	const cEl=document.getElementById('usageChart'); if(cEl && cEl.style.height && parseInt(cEl.style.height)>1200){ cEl.style.height='420px'; }
</script>
<?php $scripts=ob_get_clean(); require __DIR__.'/../layout.php'; ?>


