<?php $title=__('stock.ledger', 'Ingredient Storage Ledger'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-3 flex-column flex-md-row">
    <h1 class="h3 mb-3">
        <i class="fas fa-book"></i> <?= __('stock.ledger', 'Ingredient Storage Ledger') ?>
    </h1>
    <div class="gap-3">
        <a href="/samanta_crm/stock/ingredients" class="btn btn-secondary"><?= __('stock.summary_view', 'Summary View') ?></a>
        <a href="/samanta_crm/stock/ingredients?mode=ledger&export=csv" class="btn btn-success mb-2"><?= __('stock.export_csv', 'Export CSV') ?></a>
        <a href="/samanta_crm/stock/ingredients?mode=ledger&export=json" class="btn btn-success mb-2"><?= __('stock.export_json', 'Export JSON') ?></a>
        <a href="/samanta_crm/stock/ingredients?mode=ledger&export=xls" class="btn btn-success mb-2">Excel</a>
        <a href="/samanta_crm/stock/ingredients?mode=ledger&print=1" target="_blank" class="btn btn-outline-dark mb-2"><?= __('common.print', 'Print') ?></a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('stock.ledger_entries', 'Ledger Entries') ?></span>
    </div>
    <div class="card-body pt-0">
        <div class="table-responsive">
            <table class="table table-sm table-hover align-middle data-table mb-0" id="ingredientsLedgerTable">
	<thead class="table-light small">
		<tr>
			<th>ID</th>
			<th><?= __("stock.ingredient", "Ingredient") ?></th>
			<th class="d-none d-md-table-cell"><?= __("stock.location", "Location") ?></th>
			<th class="text-end"><?= __("stock.qty", "Qty") ?></th>
			<th class="d-none d-lg-table-cell"><?= __("common.unit", "Unit") ?></th>
			<th class="d-none d-md-table-cell"><?= __("stock.reason", "Reason") ?></th>
			<th class="d-none d-lg-table-cell"><?= __("stock.ref_date", "Ref Date") ?></th>
			<th class="d-none d-xl-table-cell"><?= __("stock.note", "Note") ?></th>
			<th class="d-none d-xl-table-cell"><?= __("common.created", "Created") ?></th>
			<th class="d-none d-xl-table-cell"><?= __("common.updated", "Updated") ?></th>
		</tr>
	</thead>
	<tbody class="small">
	<?php foreach($rows as $r): ?>
		<tr>
			<td><code class="small"><?= (int)$r['id'] ?></code></td>
			<td>
				<strong class="small"><?= htmlspecialchars($r['name']) ?></strong> <span class="text-muted">#<?= (int)$r['ingredient_id'] ?></span>
				<!-- Mobile-only info (phones) -->
				<div class="d-md-none small text-muted mt-1">
					<span class="badge bg-info text-dark me-1"><?= htmlspecialchars($r['location']) ?></span>
					<span class="badge bg-secondary"><?= htmlspecialchars($r['reason']) ?></span>
				</div>
				<!-- Tablet-only info -->
				<div class="d-lg-none d-none d-md-block small text-muted mt-1">
					<i class="fas fa-balance-scale me-1"></i><?= htmlspecialchars($r['unit'] ?? '') ?>
					<?php if(!empty($r['ref_date'])): ?>
						<span class="ms-2"><i class="fas fa-calendar me-1"></i><?= htmlspecialchars($r['ref_date']) ?></span>
					<?php endif; ?>
				</div>
			</td>
			<td class="d-none d-md-table-cell"><span class="badge bg-info text-dark"><?= htmlspecialchars($r['location']) ?></span></td>
			<td class="text-end"><strong><?= (int)round($r['change_qty']) ?></strong></td>
			<td class="d-none d-lg-table-cell"><?= htmlspecialchars($r['unit'] ?? '') ?></td>
			<td class="d-none d-md-table-cell"><span class="badge bg-secondary"><?= htmlspecialchars($r['reason']) ?></span></td>
			<td class="d-none d-lg-table-cell text-nowrap small"><?= htmlspecialchars($r['ref_date']) ?></td>
			<td class="d-none d-xl-table-cell text-muted"><?= htmlspecialchars($r['note'] ?? '') ?></td>
			<td class="d-none d-xl-table-cell text-nowrap small"><?= htmlspecialchars(substr($r['created_at'],0,16)) ?></td>
			<td class="d-none d-xl-table-cell text-nowrap small"><?= htmlspecialchars(substr($r['updated_at']??'',0,16)) ?></td>
		</tr>
	<?php endforeach; ?>
        </tbody>
        </table>
        </div>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span></span>
        <div class="small text-muted">
            <?= __("common.total", "Total") ?>: <?= count($rows) ?> <?= __("stock.entries", "entries") ?>
        </div>
    </div>
</div>

<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>

