<?php $title=__('stock.daily_usage', 'Daily Ingredient Usage'); ob_start(); ?>

<?php if(isset($_SESSION['success'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <?=htmlspecialchars($_SESSION['success']); unset($_SESSION['success']);?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>
<?php if(isset($_SESSION['error'])): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <?=htmlspecialchars($_SESSION['error']); unset($_SESSION['error']);?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-calendar-day"></i> <?= __('stock.daily_usage_for', 'Daily Ingredient Usage') ?>
        <small class="text-muted">(<?=htmlspecialchars($day);?>)</small>
    </h1>
    <div class="btn-group">
        <form method="post" action="/samanta_crm/stock/apply-usage-all" onsubmit="return confirm('<?= __('stock.apply_all_confirm', 'Apply all usage for this date?') ?>')" class="d-inline">
            <input type="hidden" name="apply_date" value="<?=htmlspecialchars($day);?>">
            <button class="btn btn-success">
                <i class="fas fa-check-double me-1"></i><?= __('stock.apply_all', 'Apply All') ?>
            </button>
        </form>
        <a href="/samanta_crm/stock/ingredients" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card mb-3  bg-warning-subtle">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-calendar me-1"></i><?= __('stock.select_date', 'Select Date') ?></span>
    </div>
    <div class="card-body py-3">
        <form method="get" class="row g-2 align-items-end">
            <div class="col-auto">
                <label class="form-label small mb-1"><?= __('common.date', 'Date') ?></label>
                <input type="date" name="date" value="<?=htmlspecialchars($day);?>" class="form-control">
            </div>
            <div class="col-auto">
                <button class="btn btn-primary"><?= __('stock.change_date', 'Change Date') ?></button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('stock.usage_table', 'Usage Details') ?></span>
    </div>
    <div class="card-body pt-0">
        <table class="table table-sm table-hover align-middle data-table mb-0">
  <thead><tr><th><?= __('stock.ingredient', 'Ingredient') ?></th><th class="text-end"><?= __('stock.needed', 'Needed') ?></th><th class="text-end"><?= __('stock.applied', 'Applied') ?></th><th class="text-end"><?= __('stock.to_apply', 'To Apply') ?></th><th><?= __('common.unit', 'Unit') ?></th><th class="text-end"><?= __('stock.stock', 'Stock') ?></th><th class="text-end"><?= __('stock.remaining_after', 'Remaining After') ?></th><th><?= __("common.status", "Status") ?></th><th style="width:80px"><?= __('stock.apply', 'Apply') ?></th></tr></thead>
  <tbody>
  <?php foreach($usage as $u): $rem=$u['remaining_after']; $applied=$u['applied']??0; $toApply=max(0,$u['needed']-$applied); ?>
    <tr class="<?=($rem<0?'table-danger':($rem<($u['needed']*0.2)?'table-warning':''))?>">
      <td><?=htmlspecialchars($u['name']);?></td>
  <td class="text-end"><?= (int)round($u['needed']); ?> <?= htmlspecialchars($u['unit']); ?></td>
  <td class="text-end"><?= (int)round($applied); ?> <?= htmlspecialchars($u['unit']); ?></td>
  <td class="text-end fw-semibold <?= $toApply>0?'text-danger':''; ?>"><?= (int)round($toApply); ?> <?= htmlspecialchars($u['unit']); ?></td>
      <td><?=htmlspecialchars($u['unit']);?></td>
  <td class="text-end"><?= (int)round($u['stock']); ?> <?= htmlspecialchars($u['unit']); ?></td>
  <td class="text-end"><?= (int)round($rem); ?> <?= htmlspecialchars($u['unit']); ?></td>
      <td>
        <?php if($rem<0): ?>
          <span class="badge bg-danger">Shortage</span>
        <?php elseif($rem<($u['needed']*0.2)): ?>
          <span class="badge bg-warning text-dark">Low</span>
        <?php else: ?>
          <span class="badge bg-success">OK</span>
        <?php endif; ?>
      </td>
      <td>
        <form method="post" action="/samanta_crm/stock/apply-usage-single" class="d-flex gap-1 align-items-center">
          <input type="hidden" name="ingredient_id" value="<?=$u['ingredient_id'];?>">
          <input type="hidden" name="apply_date" value="<?=htmlspecialchars($day);?>">
          <input type="hidden" name="desired_qty" value="<?= (int)round($u['needed']); ?>">
          <button class="btn btn-sm btn-outline-primary" title="Apply usage" <?= $toApply<=0? 'disabled':''; ?>>Go</button>
        </form>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
        </table>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span></span>
        <?php if(!$usage): ?>
            <div class="small text-muted"><?= __('stock.no_orders', 'No orders found for this date') ?></div>
        <?php else: ?>
            <div class="small text-muted"><?= __('common.total', 'Total') ?>: <?= count($usage) ?> <?= __('common.items', 'items') ?></div>
        <?php endif; ?>
    </div>
</div>

<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>

