<?php $title=__('restocks.title', 'Restock').' #'.$restock['id']; ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-truck-loading"></i> <?= __('restocks.title', 'Restock') ?> #<?=$restock['id'];?>
        <small class="text-muted">(<?=htmlspecialchars($restock['restock_date']);?>)</small>
    </h1>
    <div class="btn-group">
        <a href="/samanta_crm/restocks/<?=$restock['id'];?>/edit" class="btn btn-primary">
            <i class="fas fa-edit me-1"></i><?= __("common.edit", "Edit") ?>
        </a>
        <a href="/samanta_crm/restocks" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-info-circle me-1"></i><?= __('common.details', 'Details') ?></span>
    </div>
    <div class="card-body">
        <dl class="row mb-0">
            <dt class="col-sm-2"><?= __('restocks.supplier', 'Supplier') ?></dt>
            <dd class="col-sm-10"><?=htmlspecialchars($restock['supplier']??'');?></dd>
            <dt class="col-sm-2"><?= __('common.notes', 'Notes') ?></dt>
            <dd class="col-sm-10 mb-0"><?=htmlspecialchars($restock['notes']??'');?></dd>
        </dl>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-box me-1"></i><?= __('restocks.items', 'Items') ?></span>
    </div>
    <div class="card-body pt-0">
        <table class="table table-sm table-hover align-middle mb-0">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?= __('ingredients.title', 'Ingredient') ?></th>
                    <th class="text-end"><?= __('common.quantity', 'Qty') ?></th>
                    <th><?= __('units.title', 'Unit') ?></th>
                    <th><?= __('common.location', 'Location') ?></th>
                </tr>
            </thead>
            <tbody>
            <?php $tot=0; foreach($items as $i=>$it): $tot += $it['quantity']; ?>
                <tr>
                    <td><?=$i+1;?></td>
                    <td><strong><?=htmlspecialchars($it['name']);?></strong></td>
                    <td class="text-end"><?= (int)round($it['quantity']); ?></td>
                    <td><code><?=htmlspecialchars($it['unit']);?></code></td>
                    <td><span class="badge bg-secondary"><?=htmlspecialchars($it['location']);?></span></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span class="fw-bold"><?= __('common.total', 'Total') ?></span>
        <span class="fw-bold"><?= (int)round($tot); ?> <?= __('common.items', 'items') ?></span>
    </div>
</div>

<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


