<?php $title=__('restocks.create', 'Create Restock'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-truck-loading"></i> <?= __('restocks.create', 'Create Restock') ?>
    </h1>
    <div>
        <a href="/samanta_crm/restocks" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-plus me-1"></i><?= __('restocks.restock_details', 'Restock Details') ?></span>
    </div>
    <div class="card-body">
        <form method="post" action="/samanta_crm/restocks" id="restockForm">
            <div class="row mb-3 g-3">
                <div class="col-md-2">
                    <label class="form-label"><?= __('common.date', 'Date') ?></label>
                    <input type="date" name="restock_date" value="<?=date('Y-m-d');?>" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label"><?= __('restocks.supplier', 'Supplier') ?></label>
                    <input type="text" name="supplier" class="form-control" placeholder="<?= __('restocks.supplier_placeholder', 'Supplier name') ?>">
                </div>
                <div class="col-md-7">
                    <label class="form-label"><?= __('common.notes', 'Notes') ?></label>
                    <input type="text" name="notes" class="form-control" placeholder="<?= __('restocks.notes_placeholder', 'Optional notes') ?>">
                </div>
            </div>
            
            <h6 class="mb-2"><?= __('restocks.items', 'Items') ?></h6>
            <table class="table table-sm table-hover align-middle mb-3" id="restock-items">
                <thead>
                    <tr>
                        <th><?= __('ingredients.title', 'Ingredient') ?></th>
                        <th style="width:100px"><?= __('units.title', 'Unit') ?></th>
                        <th style="width:140px"><?= __('common.quantity', 'Qty') ?></th>
                        <th style="width:140px"><?= __('common.location', 'Location') ?></th>
                        <th style="width:40px"></th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            
            <button type="button" class="btn btn-outline-secondary" onclick="addRow()">
                <i class="fas fa-plus me-1"></i><?= __('restocks.add_item', 'Add Item') ?>
            </button>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="restockForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __("common.save", "Save") ?>
        </button>
        <a href="/samanta_crm/restocks" class="btn btn-secondary">
            <?= __("common.cancel", "Cancel") ?>
        </a>
    </div>
</div>

<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
<script>
const ingredients = <?=json_encode(array_map(function($i){return ['id'=>$i['id'],'name'=>$i['name'],'unit'=>$i['unit']];}, $ingredients));?>;
function addRow(){
  const tbody=document.querySelector('#restock-items tbody');
  const tr=document.createElement('tr');
  tr.innerHTML=`<td><select name="item_ingredient_id[]" class="form-select" onchange="updateUnit(this)">${ingredients.map(i=>`<option value="${i.id}">${i.name}${i.unit?(' ('+i.unit+')'):''}</option>`).join('')}</select></td>
    <td class="unit-cell"></td>
    <td><input type="text" name="item_qty[]" class="form-control" value="0"></td>
    <td><select name="item_location[]" class="form-select"><option value="MAIN">MAIN</option><option value="SEC">SEC</option></select></td>
    <td><button type="button" class="btn btn-sm btn-danger" onclick="this.closest('tr').remove()">&times;</button></td>`;
  tbody.appendChild(tr);
  updateUnit(tr.querySelector('select[name="item_ingredient_id[]"]'));
}
function updateUnit(sel){
  const tr=sel.closest('tr');
  const ing=ingredients.find(i=>i.id==sel.value);
  tr.querySelector('.unit-cell').textContent=ing && ing.unit?ing.unit:'';
}
addRow();
</script>


