<?php $title=__('report_flags.title', 'Report Flags'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-flag"></i> <?= __('report_flags.title', 'Report Flags') ?>
    </h1>
    <div>
        <a href="/samanta_crm/report-flags/create" class="btn btn-primary">
            <i class="fas fa-plus"></i> <?= __('common.add', 'Add') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('report_flags.report_flags', 'Report Flags') ?></span>
    </div>
    <div class="card-body pt-0">
        <table class="table table-sm table-hover align-middle data-table mb-0">
            <thead>
                <tr>
                    <th><?= __('report_flags.code', 'Code') ?></th>
                    <th><?= __('report_flags.label', 'Label') ?></th>
                    <th><?= __('report_flags.view_type', 'View Type') ?></th>
                    <th><?= __('report_flags.additional', 'Add.') ?></th>
                    <th><?= __('report_flags.blocked', 'Blocked') ?></th>
                    <th><?= __('common.order', 'Order') ?></th>
                    <th><?= __("common.active", "Active") ?></th>
                    <th class="text-end"><?= __('common.actions', 'Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($flags as $f): ?>
                <tr>
                    <td><code><?= htmlspecialchars($f['code']) ?></code></td>
                    <td><strong><?= htmlspecialchars($f['label']) ?></strong></td>
                    <td><span class="badge bg-info-subtle text-info-emphasis"><?= htmlspecialchars($f['view_type']??'') ?></span></td>
                    <td>
                        <?php if(!empty($f['show_additional'])): ?>
                            <span class="badge text-success"><?= __('common.yes', 'Yes') ?></span>
                        <?php else: ?>
                            <span class="text-muted">-</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if(!empty($f['show_blocked'])): ?>
                            <span class="badge text-warning"><?= __('common.yes', 'Yes') ?></span>
                        <?php else: ?>
                            <span class="text-muted">-</span>
                        <?php endif; ?>
                    </td>
                    <td><?= (int)$f['sort_order'] ?></td>
                    <td>
                        <?php if($f['is_active']): ?>
                            <span class="badge text-success"><?= __('common.yes', 'Yes') ?></span>
                        <?php else: ?>
                            <span class="badge text-secondary"><?= __('common.no', 'No') ?></span>
                        <?php endif; ?>
                    </td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <a class="btn btn-outline-primary" href="/samanta_crm/report-flags/<?= $f['id'] ?>/edit" title="<?= __('common.edit', 'Edit') ?>">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form method="POST" action="/samanta_crm/report-flags/<?= $f['id'] ?>/delete" class="d-inline" onsubmit="return confirm('<?= __('common.confirm_delete', 'Delete?') ?>')">
                                <button class="btn btn-outline-danger" title="<?= __('common.delete', 'Delete') ?>">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span></span>
        <div class="small text-muted">
            <?= __('common.total', 'Total') ?>: <?= count($flags) ?> <?= __('common.items', 'items') ?>
        </div>
    </div>
</div>

<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


