<?php $title=__('report_flags.edit', 'Edit Report Flag'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-flag"></i> <?= __('report_flags.edit', 'Edit Report Flag') ?>
    </h1>
    <div>
        <a href="/samanta_crm/report-flags" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-edit me-1"></i><?= __('report_flags.flag_details', 'Flag Details') ?></span>
    </div>
    <div class="card-body">
        <form method="POST" action="/samanta_crm/report-flags/<?= $flag['id'] ?>/update" id="flagForm">
            <div class="mb-3">
                <label class="form-label"><?= __('report_flags.code', 'Code') ?> *</label>
                <input name="code" value="<?= htmlspecialchars($flag['code']) ?>" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('report_flags.label', 'Label') ?> *</label>
                <input name="label" value="<?= htmlspecialchars($flag['label']) ?>" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.description', 'Description') ?></label>
                <textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($flag['description'] ?? '') ?></textarea>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('report_flags.view_type', 'View Type') ?></label>
                <?php $vt=$flag['view_type'] ?? 'category_summary'; ?>
                <select name="view_type" class="form-select">
                    <option value="category_summary" <?= $vt==='category_summary'?'selected':'' ?>><?= __('report_flags.view_type_summary', 'Category Summary Table') ?></option>
                    <option value="category_with_customers" <?= $vt==='category_with_customers'?'selected':'' ?>><?= __('report_flags.view_type_customers', 'Category Table + Customers Column Summary') ?></option>
                </select>
            </div>
            
            <?php if(isset($products)): ?>
            <div class="row mb-3 g-3">
                <div class="col-md-6">
                    <label class="form-label"><?= __('report_flags.include_override', 'Include Only These Products (override)') ?></label>
                    <select name="override_include[]" class="form-select" multiple size="8">
                        <?php foreach($products as $p): ?>
                            <option value="<?= $p['id'] ?>" <?= in_array($p['id'],$overrideInclude??[])?'selected':'' ?>><?= htmlspecialchars($p['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="form-text"><?= __('report_flags.include_override_help', 'If any selected, report will show only these (after customer/day filtering) and exclude all others unless also explicitly excluded.') ?></div>
                </div>
                <div class="col-md-6">
                    <label class="form-label"><?= __('report_flags.exclude_override', 'Explicitly Exclude These Products') ?></label>
                    <select name="override_exclude[]" class="form-select" multiple size="8">
                        <?php foreach($products as $p): ?>
                            <option value="<?= $p['id'] ?>" <?= in_array($p['id'],$overrideExclude??[])?'selected':'' ?>><?= htmlspecialchars($p['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="form-text"><?= __('report_flags.exclude_override_help', 'Excluded items won\'t appear even if flagged in product settings.') ?></div>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="rf_show_additional" name="show_additional" <?= !empty($flag['show_additional'])?'checked':'' ?>>
                        <label class="form-check-label" for="rf_show_additional"><?= __('report_flags.show_additional', 'Show Additional Products') ?></label>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="rf_show_blocked" name="show_blocked" <?= !empty($flag['show_blocked'])?'checked':'' ?>>
                        <label class="form-check-label" for="rf_show_blocked"><?= __('report_flags.show_blocked', 'Show Blocked Products') ?></label>
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label"><?= __('common.sort_order', 'Sort Order') ?></label>
                <input name="sort_order" value="<?= htmlspecialchars($flag['sort_order']) ?>" class="form-control" type="number">
            </div>
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="rf_active" name="is_active" <?= $flag['is_active']?'checked':'' ?>>
                <label for="rf_active" class="form-check-label"><?= __("common.active", "Active") ?></label>
            </div>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="flagForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __("common.update", "Update") ?>
        </button>
        <a class="btn btn-secondary" href="/samanta_crm/report-flags">
            <?= __("common.cancel", "Cancel") ?>
        </a>
    </div>
</div>

<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


