<?php $title=__('report_flags.create', 'Add Report Flag'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-flag"></i> <?= __('report_flags.create', 'Add Report Flag') ?>
    </h1>
    <div>
        <a href="/samanta_crm/report-flags" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-plus me-1"></i><?= __('report_flags.flag_details', 'Flag Details') ?></span>
    </div>
    <div class="card-body">
        <form method="POST" action="/samanta_crm/report-flags" id="flagForm">
            <div class="mb-3">
                <label class="form-label"><?= __('report_flags.code', 'Code') ?> *</label>
                <input name="code" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('report_flags.label', 'Label') ?> *</label>
                <input name="label" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.description', 'Description') ?></label>
                <textarea name="description" class="form-control" rows="3"></textarea>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('report_flags.view_type', 'View Type') ?></label>
                <select name="view_type" class="form-select">
                    <option value="category_summary"><?= __('report_flags.view_type_summary', 'Category Summary Table') ?></option>
                    <option value="category_with_customers"><?= __('report_flags.view_type_customers', 'Category Table + Customers Column Summary') ?></option>
                </select>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="rf_show_additional" name="show_additional">
                        <label class="form-check-label" for="rf_show_additional"><?= __('report_flags.show_additional', 'Show Additional Products') ?></label>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="rf_show_blocked" name="show_blocked">
                        <label class="form-check-label" for="rf_show_blocked"><?= __('report_flags.show_blocked', 'Show Blocked Products') ?></label>
                    </div>
                </div>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.sort_order', 'Sort Order') ?></label>
                <input name="sort_order" value="0" class="form-control" type="number">
            </div>
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="rf_active" name="is_active" checked>
                <label for="rf_active" class="form-check-label"><?= __("common.active", "Active") ?></label>
            </div>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="flagForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __("common.save", "Save") ?>
        </button>
        <a class="btn btn-secondary" href="/samanta_crm/report-flags">
            <?= __("common.cancel", "Cancel") ?>
        </a>
    </div>
</div>

<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


