<div class="row g-3 mb-3">
  <div class="col-md-2"><label class="form-label"><?= __('common.code', 'Code') ?> *</label><input name="code" value="<?= htmlspecialchars($product['code']??'') ?>" class="form-control form-control-sm" required></div>
  <div class="col-md-4"><label class="form-label"><?= __('common.name', 'Name') ?> *</label><input name="name" value="<?= htmlspecialchars($product['name']??'') ?>" class="form-control form-control-sm" required></div>
  <div class="col-md-3"><label class="form-label"><?= __('common.category', 'Category') ?></label><select name="category_id" class="form-select form-select-sm"><option value=""><?= __('common.none', '-- none --') ?></option><?php foreach($categories as $c): ?><option value="<?= $c['id'] ?>" <?= isset($product['category_id']) && $product['category_id']==$c['id']?'selected':'' ?>><?= htmlspecialchars($c['name']) ?></option><?php endforeach; ?></select></div>
  <div class="col-md-1"><label class="form-label"><?= __('common.sort', 'Sort') ?></label><input name="sort_order" value="<?= htmlspecialchars($product['sort_order']??0) ?>" class="form-control form-control-sm"></div>
  <div class="col-md-2"><label class="form-label"><?= __('common.status', 'Status') ?></label><select name="status" class="form-select form-select-sm"><?php $st=$product['status']??'active'; foreach(['active'=>__('common.active', 'Active'),'notactive'=>__('common.inactive', 'Inactive'),'blocked'=>__('common.blocked', 'Blocked')] as $value=>$label){ echo '<option '.($st==$value?'selected':'').' value="'.$value.'">'.$label.'</option>'; } ?></select></div>
  <div class="col-md-6"><label class="form-label"><?= __('common.description', 'Description') ?></label><textarea name="description" class="form-control form-control-sm" rows="2"><?= htmlspecialchars($product['description']??'') ?></textarea></div>
  <div class="col-md-2"><label class="form-label"><?= __('common.price', 'Price') ?></label><input name="price" value="<?= htmlspecialchars($product['price']??'') ?>" class="form-control form-control-sm"></div>
  <div class="col-md-2"><label class="form-label"><?= __('products.price_unit', 'Price Unit') ?></label>
    <select name="price_unit" class="form-select form-select-sm" onchange="toggleCustomUnit(this)">
      <option value="">--</option>
      <?php $pu=$product['price_unit']??''; foreach(($units??[]) as $u): ?>
        <option value="<?= htmlspecialchars($u['code']) ?>" <?= $pu==$u['code']?'selected':'' ?>><?= htmlspecialchars($u['code']) ?></option>
      <?php endforeach; ?>
      <option value="__custom__" <?= ($pu && !in_array($pu,array_column($units??[], 'code')))?'selected':'' ?>><?= __('common.custom', 'Custom...') ?></option>
    </select>
    <input type="text" name="price_unit_custom" value="<?= ($pu && !in_array($pu,array_column($units??[], 'code')))?htmlspecialchars($pu):'' ?>" class="form-control form-control-sm mt-1 d-none" placeholder="<?= __('common.custom_unit', 'Custom unit') ?>">
  </div>
  <div class="col-md-2"><label class="form-label"><?= __('products.factor', 'Factor') ?></label><input name="factor" value="<?= htmlspecialchars($product['factor']??'') ?>" class="form-control form-control-sm" placeholder="<?= __('products.factor_example', 'e.g. 0.25') ?>"></div>
  <div class="col-md-2"><label class="form-label"><?= __('products.production_unit', 'Prod. Unit') ?></label>
    <select name="production_unit" class="form-select form-select-sm" onchange="toggleCustomProdUnit(this)">
      <option value="">--</option>
      <?php $pu2=$product['production_unit']??''; foreach(($units??[]) as $u): ?>
        <option value="<?= htmlspecialchars($u['code']) ?>" <?= $pu2==$u['code']?'selected':'' ?>><?= htmlspecialchars($u['code']) ?></option>
      <?php endforeach; ?>
      <option value="__custom__" <?= ($pu2 && !in_array($pu2,array_column($units??[], 'code')))?'selected':'' ?>><?= __('common.custom', 'Custom...') ?></option>
    </select>
    <input type="text" name="production_unit_custom" value="<?= ($pu2 && !in_array($pu2,array_column($units??[], 'code')))?htmlspecialchars($pu2):'' ?>" class="form-control form-control-sm mt-1 d-none" placeholder="<?= __('common.custom_unit', 'Custom unit') ?>">
  </div>
  <div class="col-md-3"><label class="form-label"><?= __('products.production_site', 'Production Site') ?></label>
    <select name="production_site" class="form-select form-select-sm">
      <option value="">--</option>
      <?php $psel=$product['production_site']??''; foreach(($productionSites??[]) as $ps): ?>
        <option value="<?= htmlspecialchars($ps['code']) ?>" <?= $psel==$ps['code']?'selected':'' ?>><?= htmlspecialchars($ps['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-9"><label class="form-label"><?= __('common.notes', 'Notes') ?></label><input name="notes" value="<?= htmlspecialchars($product['notes']??'') ?>" class="form-control form-control-sm"></div>
  <div class="col-12"><label class="form-label"><?= __('products.report_flags', 'Report Flags') ?></label><div class="d-flex flex-wrap gap-2">
    <?php $selected=isset($product['report_flags'])? (is_array($product['report_flags'])?$product['report_flags']:json_decode($product['report_flags'],true)) : ($report_flags??[]); foreach(($reportFlags??[]) as $rf): $val=$rf['code']; $id='flag_'.$rf['id']; $is=in_array($val,$selected??[]); ?>
      <div class="form-check form-check-inline"><input class="form-check-input" id="<?= $id ?>" type="checkbox" name="report_flags[]" value="<?= htmlspecialchars($val) ?>" <?= $is?'checked':'' ?>><label class="form-check-label" for="<?= $id ?>"><?= htmlspecialchars($rf['label']) ?></label></div>
    <?php endforeach; ?>
  </div></div>
</div>
<hr>
<h5><?= __('products.ingredients', 'Ingredients') ?></h5>
<div id="ingredients-wrapper">
  <div class="row fw-bold small mb-1"><div class="col-md-5"><?= __('products.ingredient', 'Ingredient') ?></div><div class="col-md-2"><?= __('common.quantity', 'Qty') ?></div><div class="col-md-2"><?= __('common.unit', 'Unit') ?></div><div class="col-md-2">&nbsp;</div></div>
  <?php $existing = $product_ingredients ?? []; if(!$existing) { $existing=[[]]; } foreach($existing as $idx=>$pi): ?>
    <div class="row g-1 align-items-center mb-1 ingredient-row">
      <div class="col-md-5"><select name="ingredient_id[]" class="form-select form-select-sm"><option value=""><?= __('products.select_ingredient', '-- ingredient --') ?></option><?php foreach($ingredients as $ing): ?><option value="<?= $ing['id'] ?>" <?= isset($pi['ingredient_id']) && $pi['ingredient_id']==$ing['id']?'selected':'' ?>><?= htmlspecialchars($ing['name']) ?></option><?php endforeach; ?></select></div>
      <div class="col-md-2"><input name="ingredient_qty[]" value="<?= htmlspecialchars($pi['quantity']??'') ?>" class="form-control form-control-sm"></div>
      <div class="col-md-2"><input name="ingredient_unit[]" value="<?= htmlspecialchars($pi['unit']??'') ?>" class="form-control form-control-sm" placeholder="<?= __('products.unit_placeholder', 'szt/kg') ?>"></div>
      
      <div class="col-md-2"><button type="button" class="btn btn-sm btn-outline-danger" onclick="this.closest('.ingredient-row').remove()">X</button></div>
    </div>
  <?php endforeach; ?>
</div>
<button type="button" class="btn btn-sm btn-outline-secondary" onclick="addIngredientRow()"><i class="fas fa-plus"></i> <?= __('products.add_ingredient', 'Add Ingredient') ?></button>
<script>
function addIngredientRow(){
  const wrapper=document.getElementById('ingredients-wrapper');
  const html=`<div class=\"row g-1 align-items-center mb-1 ingredient-row\">`+
    `<div class=\"col-md-5\"><select name=\"ingredient_id[]\" class=\"form-select form-select-sm\"><option value=\"\">-- ingredient --</option><?php foreach($ingredients as $ing): ?><option value=\"<?= $ing['id'] ?>\"><?= htmlspecialchars($ing['name']) ?></option><?php endforeach; ?></select></div>`+
    `<div class=\"col-md-2\"><input name=\"ingredient_qty[]\" class=\"form-control form-control-sm\"></div>`+
    `<div class=\"col-md-2\"><input name=\"ingredient_unit[]\" class=\"form-control form-control-sm\" placeholder=\"szt/kg\"></div>`+
    `<div class=\"col-md-2\"><button type=\"button\" class=\"btn btn-sm btn-outline-danger\" onclick=\"this.closest('.ingredient-row').remove()\">X</button></div>`+
    `</div>`;
  wrapper.insertAdjacentHTML('beforeend', html);
}
function toggleCustomUnit(sel){ const input=sel.parentElement.querySelector('input[name="price_unit_custom"]'); if(sel.value==='__custom__'){ input.classList.remove('d-none'); input.focus(); } else { input.classList.add('d-none'); } }
function toggleCustomProdUnit(sel){ const input=sel.parentElement.querySelector('input[name="production_unit_custom"]'); if(sel.value==='__custom__'){ input.classList.remove('d-none'); input.focus(); } else { input.classList.add('d-none'); } }
// On load ensure proper visibility
document.querySelectorAll('select[name="price_unit"], select[name="production_unit"]').forEach(s=>{ if(s.value==='__custom__') { const ev=new Event('change'); s.dispatchEvent(ev); } });
</script>


