<?php $title=__('production_sites.edit', 'Edit Production Site'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-industry"></i> <?= __('production_sites.edit', 'Edit Production Site') ?>
    </h1>
    <div>
        <a href="/samanta_crm/production-sites" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-edit me-1"></i><?= __('production_sites.site_details', 'Site Details') ?></span>
    </div>
    <div class="card-body">
        <form method="POST" action="/samanta_crm/production-sites/<?= $site['id'] ?>/update" id="siteForm">
            <div class="mb-3">
                <label class="form-label"><?= __('production_sites.code', 'Code') ?> *</label>
                <input name="code" value="<?= htmlspecialchars($site['code']) ?>" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.name', 'Name') ?> *</label>
                <input name="name" value="<?= htmlspecialchars($site['name']) ?>" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.description', 'Description') ?></label>
                <textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($site['description'] ?? '') ?></textarea>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.sort_order', 'Sort Order') ?></label>
                <input name="sort_order" value="<?= htmlspecialchars($site['sort_order']) ?>" class="form-control" type="number">
            </div>
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="ps_active" name="is_active" <?= $site['is_active']?'checked':'' ?>>
                <label for="ps_active" class="form-check-label"><?= __("common.active", "Active") ?></label>
            </div>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="siteForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __("common.update", "Update") ?>
        </button>
        <a class="btn btn-secondary" href="/samanta_crm/production-sites">
            <?= __("common.cancel", "Cancel") ?>
        </a>
    </div>
</div>
</div>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


