<?php $title=__('orders.order_number', 'Order #').($order['id']??''); ob_start(); ?>
<div class="d-flex justify-content-between align-items-center mb-4  col-md-auto  flex-column flex-md-row">
  <h1 class="h3 mb-3">
    <i class="fas fa-receipt"></i> <?= __('orders.order', 'Order') ?> #<?= $order['id'] ?>
  </h1>
  <div class=" gap-3 d-flex flex-wrap  flex-row flex-md-row">
    <a href="/samanta_crm/orders/<?= $order['id'] ?>/edit" class="btn btn-primary">
      <i class="fas fa-edit"></i> <?= __('common.edit', 'Edit') ?>
    </a>
    <a href="/samanta_crm/orders/<?= $order['id'] ?>?export=csv" class="btn btn-secondary">
      <i class="fas fa-file-csv"></i> CSV
    </a>
    <a href="/samanta_crm/orders/<?= $order['id'] ?>?export=excel" class="btn btn-secondary">
      <i class="fas fa-file-excel"></i> Excel
    </a>
    <button onclick="window.print()" class="btn btn-secondary">
      <i class="fas fa-print"></i> <?= __('common.print', 'Print') ?>
    </button>
    <a href="/samanta_crm/orders" class="btn btn-primary">
      <i class="fas fa-arrow-left"></i> <?= __('common.back', 'Back') ?>
    </a>
  </div>
</div>

<!-- Order Details Card -->
<div class="card mb-3">
  <div class="card-header py-2">
    <span class="small fw-bold">
      <i class="fas fa-info-circle me-1"></i><?= __('orders.order_details', 'Order Details') ?>
    </span>
  </div>
  <div class="card-body">
    <div class="row">
      <div class="col-md-6">
        <table class="table table-borderless table-sm mb-0">
          <tr>
            <td class="fw-bold" style="width: 140px;"><?= __('common.customer', 'Customer') ?>:</td>
            <td><?= htmlspecialchars($order['customer_name']) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.order_date', 'Order Date') ?>:</td>
            <td><?= htmlspecialchars(date('Y-m-d', strtotime($order['order_date']))) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.order_time', 'Order Time') ?>:</td>
            <td><?= htmlspecialchars(date('H:i', strtotime($order['order_date']))) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.delivery_date', 'Delivery Date') ?>:</td>
            <td><?= htmlspecialchars($order['delivery_date'] ?? __('common.not_specified', 'Not specified')) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.order_type', 'Order Type') ?>:</td>
            <td class="text-capitalize"><?= htmlspecialchars($order['order_type'] ?? 'daily') ?></td>
          </tr>
        </table>
      </div>
      <div class="col-md-6">
        <table class="table table-borderless table-sm mb-0">
          <tr>
            <td class="fw-bold" style="width: 140px;"><?= __('common.status', 'Status') ?>:</td>
            <td class="text-capitalize"><?= htmlspecialchars($order['status']) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.assigned_user', 'Assigned User') ?>:</td>
            <td><?= htmlspecialchars($order['assigned_user_name'] ?? __('common.not_assigned', 'Not assigned')) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.verified', 'Verified') ?>:</td>
            <td><?= !empty($order['confirmed']) ? __('common.yes', 'Yes') : __('common.no', 'No') ?></td>
          </tr>
          <?php if(!empty($order['notes'])): ?>
          <tr>
            <td class="fw-bold"><?= __('common.notes', 'Notes') ?>:</td>
            <td><?= nl2br(htmlspecialchars($order['notes'])) ?></td>
          </tr>
          <?php endif; ?>
          <?php if(!empty($order['signature'])): ?>
          <tr>
            <td class="fw-bold"><?= __('orders.signature', 'Signature') ?>:</td>
            <td><?= nl2br(htmlspecialchars($order['signature'])) ?></td>
          </tr>
          <?php endif; ?>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Order Items Card -->
<div class="card">
  <div class="card-header py-2">
    <span class="small fw-bold">
      <i class="fas fa-list me-1"></i><?= __('orders.order_items', 'Order Items') ?>
    </span>
  </div>
  <div class="card-body pt-0">
    <div class="table-responsive">
      <table class="table table-sm table-hover align-middle mb-0" id="orderItemsTable">
        <thead class="table-light">
          <tr>
            <th class="d-none d-md-table-cell" style="width:100px"><?= __("common.code", "Code") ?></th>
            <th><?= __("common.name", "Name") ?></th>
            <th style="width:80px" class="text-center"><?= __("common.quantity", "Qty") ?></th>
            <th class="d-none d-lg-table-cell" style="width:80px" class="text-center"><?= __("common.units", "Units") ?></th>
          </tr>
        </thead>
      <tbody>
        <?php foreach($items as $it): $qty=(float)$it['quantity']; $code=htmlspecialchars(($it['product_code_snapshot']??'') ?: ($it['code']??'')); $unit=htmlspecialchars(($it['price_unit'] ?? '') ?: ($it['production_unit'] ?? '')); ?>
          <tr>
            <td class="d-none d-md-table-cell"><code class="small"><?= $code ?></code></td>
            <td>
              <strong class="small"><?= htmlspecialchars(($it['product_name_snapshot']??'') ?: ($it['name']??'')) ?></strong>
              <!-- Mobile-only info (phones) -->
              <div class="d-md-none small text-muted mt-1">
                <code class="me-2"><?= $code ?></code>
                <span class="badge bg-secondary"><?= $unit ?></span>
              </div>
            </td>
            <td class="text-center"><strong><?= number_format($qty,1) ?></strong></td>
            <td class="text-center d-none d-lg-table-cell"><?= $unit ?></td>
          </tr>
        <?php endforeach; if(!$items): ?>
          <tr><td colspan="4" class="text-muted text-center py-3"><?= __("orders.no_items", "No items in this order") ?></td></tr>
        <?php endif; ?>
      </tbody>
      </table>
    </div>
  </div>
</div>

<style>@media print{body{background:#fff;} .btn,.btn-group,nav,.navbar,form{display:none!important;} .card{border:1px solid #000!important;} .card-header{background:#f8f9fa!important;border-bottom:1px solid #000!important;} }</style>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>


