
  <div class="row">
    <div class="col-md-6  mb-3">
      <div class="card">
        <div class="card-header py-2 d-flex">
          <span class="small fw-bold"><i class="fas fa-info-circle me-1"></i><?= __('orders.order_details', 'Order Details') ?></span>
        </div>
        <div class="card-body">
            <div class="col-12 g-3"> 
              <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label"><?= __('orders.assigned_user', 'Assigned User') ?></label>
                    <select name="assigned_user_id" class="form-select" id="assignedUserSelect">
                      <option value=""><?= __('common.none', '-- none --') ?></option>
                      <?php foreach($users as $u): ?>
                        <option value="<?= $u['id'] ?>" <?= isset($order['assigned_user_id']) && $order['assigned_user_id']==$u['id']?'selected':'' ?>><?= htmlspecialchars($u['name']) ?></option>
                      <?php endforeach; ?>
                    </select>
                  </div>  
                <div class="col-md-6 mb-3">
                  <label class="form-label"><?= __('common.customer', 'Customer') ?> *</label>
                  <select name="customer_id" class="form-select" required>
                    <option value=""><?= __('common.select', '-- select --') ?></option>
                    <?php foreach($customers as $c): ?>
                      <option value="<?= $c['id'] ?>" <?= (isset($order) && isset($order['customer_id']) && $order['customer_id']==$c['id'])?'selected':'' ?>><?= htmlspecialchars($c['name']) ?></option>
                    <?php endforeach; ?>
                  </select>
                  </div>
              
                  <?php
                    $orderDateVal = $order['order_date'] ?? date('Y-m-d H:i:s');
                    $orderDatePart = substr($orderDateVal,0,10);
                    $orderTimePart = substr($orderDateVal,11,5);
                  ?>
                <div class="col-md-6 mb-3">
                  <label class="form-label"><?= __('orders.order_date', 'Order Date') ?></label>
                  <input type="date" name="order_date" id="orderDate" class="form-control" value="<?= htmlspecialchars($orderDatePart) ?>" min="<?= date('Y-m-d') ?>">
                  </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label"><?= __('orders.order_time', 'Order Time') ?></label>
                  <input type="time" name="order_time" id="orderTime" class="form-control" value="<?= htmlspecialchars($orderTimePart) ?>">
                  </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label"><?= __('orders.delivery_date', 'Delivery Date') ?></label>
                  <input type="date" name="delivery_date" id="deliveryDate" class="form-control" value="<?= htmlspecialchars($order['delivery_date']??'') ?>" min="<?= date('Y-m-d') ?>" placeholder="<?= __('common.optional', '(optional)') ?>">
                  </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label"><?= __('orders.order_type', 'Order Type') ?></label>
                  <?php $ot=$order['order_type']??'daily'; ?>
                  <select name="order_type" class="form-select">
                    <option value="daily" <?= $ot==='daily'?'selected':'' ?>><?= __('orders.type_daily', 'Daily Order') ?></option>
                    <option value="additional" <?= $ot==='additional'?'selected':'' ?>><?= __('orders.type_additional', 'Additional Order') ?></option>
                  </select>
                  </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label"><?= __('common.status', 'Status') ?></label>
                  <?php $st=$order['status']??'pending'; ?>
                  <select name="status" class="form-select">
                    <option value="pending" <?= $st==='pending'?'selected':'' ?>><?= __('orders.status_pending', 'Pending') ?></option>
                    <option value="completed" <?= $st==='completed'?'selected':'' ?>><?= __('orders.status_completed', 'Completed') ?></option>
                    <option value="cancelled" <?= $st==='cancelled'?'selected':'' ?>><?= __('orders.status_cancelled', 'Cancelled') ?></option>
                  </select>
                  </div>
              
                <div class="col-md-6 d-flex align-items-end">
                  <div class="form-check mt-auto">
                    <input class="form-check-input" type="checkbox" name="confirm_flag" value="1" id="confirmFlag" <?= !empty($order['confirmed'])?'checked':'' ?>>
                    <label class="form-check-label small" for="confirmFlag" title="<?= __('orders.verified_tooltip', 'Production manager verified; order will be processed') ?>"><?= __('orders.verified', 'Verified') ?></label>
                  </div>
                  </div>
               
              </div>
            </div>
        </div>  
      </div>
    </div>
                  
    <div class="col-md-6  mb-3">
      <div class="card">
        <div class="card-header py-2 d-flex justify-content-between">
          <span class="small fw-bold"><i class="fas fa-list me-1"></i><?= __('orders.items_summary', 'Items Summary') ?></span>
               
        </div>
        <div class="card-body">    
               
                <div class="col-md-12">
              
                <div class="table-responsive" style="max-height:200px;overflow:auto;">
                  <table class="table table-sm table-bordered mb-0" id="itemsSummaryTable">
                    <thead class="table-light"><tr><th><?= __('common.code', 'Code') ?></th><th><?= __('common.name', 'Name') ?></th><th style="width:70px"><?= __('common.quantity', 'Qty') ?></th><th style="width:70px"><?= __('common.units', 'Units') ?></th></tr></thead>
                    <tbody><tr class="no-items"><td colspan="4" class="text-muted"><?= __('orders.no_items', 'No items') ?></td></tr></tbody>
                  </table>
                </div>
                <div class="d-flex align-items-end p-3">
                  <button type="button" class="btn  btn-primary w-100 ms-auto" data-bs-toggle="modal" data-bs-target="#modalItems"><i class="fas fa-plus"></i> <?= __('orders.items', 'Items') ?></button>
                </div>      
              </div>
              <hr>
              
              <div class="mb-3">
                  <label class="form-label"><?= __('common.notes', 'Notes') ?></label>
                  <textarea name="notes" class="form-control" rows="2"><?= htmlspecialchars($order['notes']??'') ?></textarea>
                </div>
              <div class="col-md-6 offset-md-6">
                <label class="form-label"><?= __('orders.signature', 'Signature') ?></label>
                <textarea name="signature" class="form-control" rows="2" placeholder="<?= __('orders.signature_placeholder', 'Signature / Acknowledgement text') ?>"><?= htmlspecialchars($order['signature']??'') ?></textarea>
              </div>

          </div>
          <div class="card-footer py-2 d-flex gap-2 justify-content-end">
              <button type="submit" form="orderForm" class="btn btn-primary">
                  <i class="fas fa-save me-1"></i><?= __("common.save", "Save") ?>
              </button>
              <a href="/samanta_crm/orders" class="btn btn-secondary">
                  <?= __("common.cancel", "Cancel") ?>
              </a>
          </div>
        </div>  
    </div>
  </div>

<!-- Hidden item inputs container -->
<div id="orderItemsHidden" class="d-none">
<?php if(!empty($items)):
  foreach($items as $it): ?>
  <div class="order-item-hidden" data-id="<?= $it['product_id'] ?>">
    <input type="hidden" name="item_product_id[]" value="<?= $it['product_id'] ?>">
  <input type="hidden" name="item_qty[]" value="<?= htmlspecialchars($it['quantity'] ?? '') ?>">
  <input type="hidden" name="item_name_snapshot[]" value="<?= htmlspecialchars(($it['product_name_snapshot'] ?? '') ?: ($it['name'] ?? '')) ?>">
  <input type="hidden" name="item_code_snapshot[]" value="<?= htmlspecialchars(($it['product_code_snapshot'] ?? '') ?: ($it['code'] ?? '')) ?>">
  <input type="hidden" name="item_units_snapshot[]" value="<?= htmlspecialchars(($it['price_unit'] ?? '') ?: ($it['production_unit'] ?? '')) ?>">
  </div>
<?php endforeach; endif; ?>
</div>


