<?php $title=__('orders.edit_order', 'Edit Order'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-receipt"></i> <?= __('orders.edit_order', 'Edit Order') ?> #<?= $order['id'] ?>
    </h1>
    <div>
        <a href="/samanta_crm/orders" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card" id="orderEditCard">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-edit me-1"></i><?= __('orders.order_details', 'Order Details') ?></span>
    </div>
    <div class="card-body">
        <form method="POST" action="/samanta_crm/orders/<?= $order['id'] ?>/update" id="orderForm">
            <?php require __DIR__.'/form_fields.php'; ?>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="orderForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __("common.update", "Update") ?>
        </button>
        <a href="/samanta_crm/orders" class="btn btn-secondary">
            <?= __("common.cancel", "Cancel") ?>
        </a>
    </div>
</div>

<?php require __DIR__.'/items_modal.php'; ?>

<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>


