<?php $title='Dashboard'; ob_start(); ?>
<h1 class="h3 mb-4"><i class="fas fa-tachometer-alt me-2"></i>Dashboard</h1>

<div class="row g-3">
    <div class="col-sm-6 col-lg-3">
        <div class="card shadow-sm h-100 border-0 bg-primary text-white">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="small text-uppercase opacity-75">Users</div>
                        <div class="fw-bold display-6 fs-3"><?= (int)$totalUsers ?></div>
                    </div>
                    <i class="fas fa-users fa-2x opacity-75"></i>
                </div>
            </div>
            <a href="/samanta_crm/users" class="stretched-link"></a>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card shadow-sm h-100 border-0 bg-success text-white">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="small text-uppercase opacity-75">Applied Days</div>
                        <div class="fw-bold fs-3" id="dashAppliedDays">-</div>
                    </div>
                    <i class="fas fa-history fa-2x opacity-75"></i>
                </div>
            </div>
            <a href="/samanta_crm/stock/usage-history" class="stretched-link"></a>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card shadow-sm h-100 border-0 bg-warning text-dark">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="small text-uppercase fw-semibold">Pending Usage (Today)</div>
                        <div class="fw-bold fs-4" id="dashPendingUsage">-</div>
                    </div>
                    <i class="fas fa-exclamation-triangle fa-2x opacity-75"></i>
                </div>
            </div>
            <a href="/samanta_crm/stock/ingredients" class="stretched-link"></a>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card shadow-sm h-100 border-0 bg-info text-white">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="small text-uppercase">Low Stock</div>
                        <div class="fw-bold fs-3" id="dashLowStock">-</div>
                    </div>
                    <i class="fas fa-warehouse fa-2x opacity-75"></i>
                </div>
            </div>
            <a href="/samanta_crm/stock/ingredients" class="stretched-link"></a>
        </div>
    </div>
</div>

<div class="row g-3 mt-2">
    <div class="col-xl-8">
        <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center py-2">
                <strong><i class="fas fa-chart-line me-2"></i>Usage & Stock (Last 14d)</strong>
                <a href="/samanta_crm/stock/usage-chart" class="small text-decoration-none">Full Chart</a>
            </div>
            <div class="card-body">
                <canvas id="miniUsageChart" height="110"></canvas>
            </div>
        </div>
    </div>
    <div class="col-xl-4">
        <div class="card h-100">
            <div class="card-header py-2"><strong><i class="fas fa-bolt me-2"></i>Quick Actions</strong></div>
            <div class="card-body small">
                <div class="row g-2">
                    <div class="col-6 d-grid"><a class="btn btn-sm btn-outline-primary" href="/samanta_crm/orders/create"><i class="fas fa-plus"></i> Order</a></div>
                    <div class="col-6 d-grid"><a class="btn btn-sm btn-outline-success" href="/samanta_crm/restocks/create"><i class="fas fa-dolly"></i> Restock</a></div>
                    <div class="col-6 d-grid"><a class="btn btn-sm btn-outline-warning" href="/samanta_crm/stock/ingredients"><i class="fas fa-warehouse"></i> Stock</a></div>
                    <div class="col-6 d-grid"><a class="btn btn-sm btn-outline-danger" href="/samanta_crm/stock/usage-history"><i class="fas fa-history"></i> Applied</a></div>
                    <div class="col-6 d-grid"><a class="btn btn-sm btn-outline-secondary" href="/samanta_crm/ingredient-storage"><i class="fas fa-box-open"></i> Storage</a></div>
                    <div class="col-6 d-grid"><a class="btn btn-sm btn-outline-info" href="/samanta_crm/stock/usage-chart"><i class="fas fa-chart-line"></i> Chart</a></div>
                    <div class="col-6 d-grid"><a class="btn btn-sm btn-outline-dark" href="/samanta_crm/reports/daily/ingredients"><i class="fas fa-seedling"></i> Daily Ing.</a></div>
                    <div class="col-6 d-grid"><a class="btn btn-sm btn-outline-dark" href="/samanta_crm/reports/daily"><i class="fas fa-calendar-day"></i> Daily Report</a></div>
                </div>
                <hr>
                <div class="small text-muted">Shortcuts tailored to inventory workflows.</div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mt-2">
    <div class="col-lg-6">
        <div class="card h-100">
            <div class="card-header py-2"><strong><i class="fas fa-user-clock me-2"></i>Recent Users</strong></div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm mb-0 table-hover">
                        <thead class="table-light"><tr><th><?= __("common.name", "Name") ?></th><th><?= __("common.email", "Email") ?></th><th>Role</th><th>Created</th></tr></thead>
                        <tbody>
                        <?php if(empty($users)): ?><tr><td colspan="4" class="text-center text-muted">No users.</td></tr><?php else: foreach(array_slice($users,0,5) as $u): ?>
                            <tr>
                                <td><?= htmlspecialchars($u['name']??'') ?></td>
                                <td><?= htmlspecialchars($u['email']??'') ?></td>
                                <td><span class="badge bg-<?= ($u['role']??'')==='admin'?'danger':'primary' ?>"><?= htmlspecialchars(ucfirst($u['role']??'')) ?></span></td>
                                <td><?= isset($u['created_at'])?date('Y-m-d',strtotime($u['created_at'])):'' ?></td>
                            </tr>
                        <?php endforeach; endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card h-100">
            <div class="card-header py-2"><strong><i class="fas fa-info-circle me-2"></i>System / Environment</strong></div>
            <div class="card-body small">
                <div class="row g-3">
                    <div class="col-6"><strong>PHP:</strong> <?= PHP_VERSION ?></div>
                    <div class="col-6"><strong>Env:</strong> <?= APP_ENV ?></div>
                    <div class="col-6"><strong>Time:</strong> <?= date('Y-m-d H:i') ?></div>
                    <div class="col-6"><strong>User:</strong> <?= htmlspecialchars($_SESSION['user_name']??'') ?></div>
                </div>
                <hr>
                <div class="text-muted small">Inventory centric dashboard highlights pending usage that still needs applying, recent applied days, and low stock count.</div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
(function(){
    // Fetch lightweight metrics via inline PHP endpoints (quick queries embedded)
    fetch('/samanta_crm/api/dashboard-metrics')
        .then(r=>r.json()).then(d=>{
            if(d.applied_days!==undefined) document.getElementById('dashAppliedDays').textContent=d.applied_days;
            if(d.pending_usage_today!==undefined) document.getElementById('dashPendingUsage').textContent=d.pending_usage_today.toFixed(2).replace(/\.0+$/,'');
            if(d.low_stock!==undefined) document.getElementById('dashLowStock').textContent=d.low_stock;
            buildMiniChart(d.chart || {});
        }).catch(()=>{});
    function buildMiniChart(c){
        if(!c.labels) return; const ctx=document.getElementById('miniUsageChart'); if(!ctx) return;
        new Chart(ctx,{type:'line',data:{labels:c.labels,datasets:[{label:'Stock',data:c.stock,borderColor:'#0d6efd',backgroundColor:'rgba(13,110,253,.15)',tension:.25,fill:true},{label:'Applied',data:c.applied,type:'bar',backgroundColor:'#dc3545',borderColor:'#dc3545'}]},options:{plugins:{legend:{display:true}},responsive:true,scales:{y:{beginAtZero:true}}}});
    }
})();
</script>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


