<div class="row">
    <div class="col-lg-8 mx-auto">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="fas fa-spinner fa-spin me-2"></i>Importowanie Zamówień...</h4>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Import w toku...</strong> Proszę nie zamykać okna przeglądarki.
                </div>

                <div class="mb-4">
                    <h5>Postęp importu:</h5>
                    <div class="row g-3">
                        <div class="col-md-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <i class="fas fa-list-ol text-primary fa-2x mb-2"></i>
                                    <h3 class="mb-0"><?= $progress['total'] ?></h3>
                                    <small class="text-muted">Przetworzonych</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <i class="fas fa-check-circle text-success fa-2x mb-2"></i>
                                    <h3 class="mb-0"><?= $progress['success'] ?></h3>
                                    <small class="text-muted">Sukces</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <i class="fas fa-forward text-warning fa-2x mb-2"></i>
                                    <h3 class="mb-0"><?= $progress['skipped'] ?></h3>
                                    <small class="text-muted">Pominięto</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <i class="fas fa-exclamation-triangle text-danger fa-2x mb-2"></i>
                                    <h3 class="mb-0"><?= $progress['errors'] ?></h3>
                                    <small class="text-muted">Błędy</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="progress mb-3" style="height: 30px;">
                    <div class="progress-bar progress-bar-striped progress-bar-animated bg-primary" 
                         role="progressbar" 
                         style="width: 100%">
                        <span class="fw-bold">Przetwarzanie kolejnej paczki...</span>
                    </div>
                </div>

                <div class="text-center">
                    <div class="spinner-border text-primary mb-3" role="status">
                        <span class="visually-hidden">Ładowanie...</span>
                    </div>
                    <p class="text-muted">
                        Automatyczne przekierowanie za <span id="countdown">2</span> sekund...<br>
                        <small>Następna paczka: <?= $progress['batch_size'] ?> rekordów</small>
                    </p>
                </div>

                <!-- Auto-submit form for next batch -->
                <form id="nextBatchForm" method="POST" action="<?= $progress['import_url'] ?? '/samanta_crm/migration/import-cake-orders' ?>">
                    <input type="hidden" name="offset" value="<?= $progress['next_offset'] ?>">
                    <input type="hidden" name="batch_size" value="<?= $progress['batch_size'] ?>">
                </form>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-body text-center">
                <p class="mb-2"><i class="fas fa-info-circle me-1"></i>Jeśli strona nie przekieruje automatycznie:</p>
                <button type="button" class="btn btn-primary" onclick="document.getElementById('nextBatchForm').submit()">
                    <i class="fas fa-play me-2"></i>Kontynuuj Import
                </button>
            </div>
        </div>
    </div>
</div>

<script>
// Countdown and auto-submit
let countdown = 0.2;
const countdownEl = document.getElementById('countdown');
const form = document.getElementById('nextBatchForm');

const interval = setInterval(() => {
    countdown--;
    if (countdownEl) {
        countdownEl.textContent = countdown;
    }
    
    if (countdown <= 0) {
        clearInterval(interval);
        form.submit();
    }
}, 200);
</script>
