<div class="row">
    <div class="col-lg-8 mx-auto">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="fas fa-file-import me-2"></i>Migracja Zamówień Tortów</h4>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Instrukcja:</strong>
                    <ul class="mb-0 mt-2">
                        <li>Prześlij plik CSV z zamówieniami z Gravity Forms</li>
                        <li>System automatycznie zaimportuje dane do nowego systemu</li>
                        <li>Klienci zostaną utworzeni lub dopasowani po numerze telefonu</li>
                        <li>Duplikaty (na podstawie Gravity Forms ID) zostaną pominięte</li>
                    </ul>
                </div>

                <?php if (isset($_SESSION['migration_errors'])): ?>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Wystąpiły błędy podczas importu</strong>
                    <p class="mb-2">Liczba błędów: <?= count($_SESSION['migration_errors']) ?></p>
                    <a href="/samanta_crm/migration/download-report" class="btn btn-sm btn-warning">
                        <i class="fas fa-download me-1"></i>Pobierz raport błędów
                    </a>
                </div>
                <?php unset($_SESSION['migration_errors']); ?>
                <?php endif; ?>

                <form method="POST" action="/samanta_crm/migration/import-cake-orders" enctype="multipart/form-data" class="mt-4">
                    <div class="mb-4">
                        <label for="csv_file" class="form-label">
                            <i class="fas fa-file-csv me-1"></i>Plik CSV z zamówieniami
                        </label>
                        <input type="file" 
                               class="form-control" 
                               id="csv_file" 
                               name="csv_file" 
                               accept=".csv" 
                               required>
                        <div class="form-text">
                            Plik musi być w formacie CSV wyeksportowany z Gravity Forms
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="batch_size" class="form-label">
                            <i class="fas fa-layer-group me-1"></i>Rozmiar paczki (liczba rekordów na raz)
                        </label>
                        <select class="form-select" id="batch_size" name="batch_size">
                            <option value="25">25 rekordów (wolniejsze, bezpieczniejsze)</option>
                            <option value="50" selected>50 rekordów (zalecane)</option>
                            <option value="100">100 rekordów (szybsze)</option>
                            <option value="200">200 rekordów (bardzo szybkie, może przekroczyć limit)</option>
                        </select>
                        <div class="form-text">
                            Dla dużych plików użyj mniejszych paczek, aby uniknąć przekroczenia limitu czasu
                        </div>
                    </div>

                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Uwaga:</strong> Import dużych plików jest przetwarzany partiami.
                        Nie zamykaj okna przeglądarki podczas importu.
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-upload me-2"></i>Importuj Zamówienia
                        </button>
                        <a href="/samanta_crm/dashboard" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Powrót do Dashboard
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <!-- Instructions Card -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-question-circle me-2"></i>Mapowanie Pól</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">System automatycznie mapuje następujące pola z CSV:</p>
                
                <div class="row">
                    <div class="col-md-6">
                        <h6>Dane Klienta:</h6>
                        <ul class="small">
                            <li>Imię i Nazwisko</li>
                            <li>Telefon</li>
                            <li>Email</li>
                        </ul>

                        <h6>Dane Zamówienia:</h6>
                        <ul class="small">
                            <li>Data i godzina odbioru</li>
                            <li>Miejsce odbioru / dostawa</li>
                            <li>Sposób płatności</li>
                            <li>Kwota zaliczki</li>
                        </ul>
                    </div>

                    <div class="col-md-6">
                        <h6>Szczegóły Tortu:</h6>
                        <ul class="small">
                            <li>Smak</li>
                            <li>Wielkość</li>
                            <li>Rodzaj (Standardowy, Okazjonalny, etc.)</li>
                            <li>Napis</li>
                            <li>Świeczki</li>
                            <li>Raca</li>
                            <li>Opłatek ze zdjęciem</li>
                            <li>Kartka/bilecik</li>
                            <li>Figurka</li>
                            <li>Uwagi</li>
                        </ul>
                    </div>
                </div>

                <div class="alert alert-info mt-3 small mb-0">
                    <strong>Automatyczne dopasowanie:</strong>
                    <ul class="mb-0">
                        <li>Smaki, rozmiary i rodzaje tortów są dopasowywane do istniejących w bazie</li>
                        <li>Jeśli nie ma dopasowania (np. "Inny" smak), tekst jest zapisywany jako wartość niestandardowa</li>
                        <li>Miejsca odbioru są dopasowywane po nazwie</li>
                        <li>Klienci są wyszukiwani i dopasowywani po numerze telefonu</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
