<div class="row">
    <div class="col-lg-8 mx-auto">
        <div class="mb-4">
            <a href="/samanta_crm/migration" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Powrót do wyboru importu
            </a>
        </div>

        <h2 class="mb-4"><i class="fas fa-birthday-cake me-2"></i>Migracja Zamówień Tortów</h2>
        
        <!-- Cake Orders Import Card -->
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="fas fa-file-import me-2"></i>Import z Gravity Forms</h4>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Instrukcja:</strong>
                    <ul class="mb-0 mt-2">
                        <li>Prześlij plik CSV z zamówieniami tortów z Gravity Forms</li>
                        <li>System automatycznie zaimportuje dane do nowego systemu</li>
                        <li>Klienci zostaną utworzeni lub dopasowani po numerze telefonu</li>
                        <li>Duplikaty (na podstawie Gravity Forms ID) zostaną pominięte</li>
                    </ul>
                </div>

                <?php if (isset($_SESSION['migration_errors'])): ?>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Wystąpiły błędy podczas importu</strong>
                    <p class="mb-2">Liczba błędów: <?= count($_SESSION['migration_errors']) ?></p>
                    <a href="/samanta_crm/migration/download-report" class="btn btn-sm btn-warning">
                        <i class="fas fa-download me-1"></i>Pobierz raport błędów
                    </a>
                </div>
                <?php unset($_SESSION['migration_errors']); ?>
                <?php endif; ?>

                <form method="POST" action="/samanta_crm/migration/import-cake-orders" enctype="multipart/form-data" class="mt-4">
                    <input type="hidden" name="offset" value="0">
                    <div class="mb-4">
                        <label for="csv_file" class="form-label">
                            <i class="fas fa-file-csv me-1"></i>Plik CSV z zamówieniami tortów
                        </label>
                        <input type="file" 
                               class="form-control form-control-lg" 
                               id="csv_file" 
                               name="csv_file" 
                               accept=".csv" 
                               required>
                        <div class="form-text">
                            Plik musi być w formacie CSV wyeksportowany z Gravity Forms
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="batch_size" class="form-label">
                            <i class="fas fa-layer-group me-1"></i>Rozmiar paczki
                        </label>
                        <select class="form-select" id="batch_size" name="batch_size">
                            <option value="25">25 rekordów</option>
                            <option value="50" selected>50 rekordów</option>
                            <option value="100">100 rekordów</option>
                            <option value="200">200 rekordów</option>
                        </select>
                        <div class="form-text">
                            Mniejsze paczki są bezpieczniejsze dla dużych plików
                        </div>
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-upload me-2"></i>Rozpocznij Import Zamówień Tortów
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Back Button -->
        <div class="text-center mt-4">
            <a href="/samanta_crm/dashboard" class="btn btn-secondary">
                <i class="fas fa-home me-2"></i>Powrót do Dashboard
            </a>
        </div>
    </div>
</div>
