<div class="container-fluid mt-4">
    <div class="row mb-4">
        <div class="col-12">
            <h2>Menu Versions & Snapshots</h2>
            <p class="text-muted">Create, manage, and export menu snapshots for different locations</p>
        </div>
    </div>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success alert-dismissible">
                <?= htmlspecialchars($_SESSION['success']) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['success']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible">
                <?= htmlspecialchars($_SESSION['error']) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['error']); ?>
        <?php endif; ?>

        <div class="row mb-4">
            <div class="col-md-4">
                <label class="form-label">Select Location:</label>
                <select class="form-select" id="locationSelect" onchange="loadLocation(this.value)">
                    <option value="">-- Choose Location --</option>
                    <?php foreach ($locations as $loc): ?>
                        <option value="<?= $loc['id'] ?>" <?= $locationId == $loc['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($loc['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <?php if ($selectedLocation): ?>
            <div class="col-md-8 text-end align-self-end">
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createVersionModal">
                    + Create New Snapshot
                </button>
            </div>
            <?php endif; ?>
        </div>

        <?php if ($selectedLocation): ?>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Snapshots for: <?= htmlspecialchars($selectedLocation['name']) ?></h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($versions)): ?>
                            <p class="text-muted text-center py-4">No snapshots created yet for this location.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Version Name</th>
                                            <th>Description</th>
                                            <th>Created At</th>
                                            <th>Created By</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($versions as $version): ?>
                                        <tr>
                                            <td><strong><?= htmlspecialchars($version['version_name']) ?></strong></td>
                                            <td><?= htmlspecialchars($version['description'] ?: '-') ?></td>
                                            <td><?= date('Y-m-d H:i', strtotime($version['created_at'])) ?></td>
                                            <td><?= htmlspecialchars($version['created_by'] ?: '-') ?></td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="/samanta_crm/menu/versions/download?id=<?= $version['id'] ?>" 
                                                       class="btn btn-outline-primary" 
                                                       title="Download JSON">
                                                        📥 JSON
                                                    </a>
                                                    <a href="/samanta_crm/menu/versions/download-viewer?id=<?= $version['id'] ?>" 
                                                       class="btn btn-outline-success" 
                                                       title="Download Standalone HTML">
                                                        📄 HTML
                                                    </a>
                                                    <button type="button" 
                                                            class="btn btn-outline-danger" 
                                                            onclick="deleteVersion(<?= $version['id'] ?>, '<?= htmlspecialchars($version['version_name'], ENT_QUOTES) ?>')"
                                                            title="Delete">
                                                        🗑️
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="row">
            <div class="col-12">
                <div class="alert alert-info">
                    <strong>👋 Welcome!</strong> Select a location above to view and manage its menu snapshots.
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Create Version Modal -->
    <?php if ($selectedLocation): ?>
    <div class="modal fade" id="createVersionModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="/samanta_crm/menu/versions/create">
                    <div class="modal-header">
                        <h5 class="modal-title">Create New Snapshot</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="location_id" value="<?= $selectedLocation['id'] ?>">
                        
                        <div class="mb-3">
                            <label class="form-label">Version Name *</label>
                            <input type="text" 
                                   name="version_name" 
                                   class="form-control" 
                                   placeholder="e.g., Winter Menu 2025" 
                                   required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea name="description" 
                                      class="form-control" 
                                      rows="3" 
                                      placeholder="Optional notes about this snapshot..."></textarea>
                        </div>
                        
                        <div class="alert alert-info mb-0">
                            <small>
                                <strong>📸 Snapshot will include:</strong><br>
                                • All active menu items for this location<br>
                                • Categories and sorting<br>
                                • Prices and descriptions<br>
                                • Images (URLs preserved)
                            </small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Create Snapshot</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Delete Form (hidden) -->
    <form id="deleteForm" method="POST" action="/samanta_crm/menu/versions/delete" style="display: none;">
        <input type="hidden" name="id" id="deleteId">
        <input type="hidden" name="location_id" value="<?= $locationId ?>">
    </form>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function loadLocation(locationId) {
            if (locationId) {
                window.location.href = '/samanta_crm/menu/versions?location_id=' + locationId;
            } else {
                window.location.href = '/samanta_crm/menu/versions';
            }
        }

        function deleteVersion(id, name) {
            if (confirm('Are you sure you want to delete snapshot "' + name + '"?')) {
                document.getElementById('deleteId').value = id;
                document.getElementById('deleteForm').submit();
            }
        }
    </script>

