<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2><i class="fas fa-map-marker-alt me-2"></i>Lokalizacje</h2>
            <p class="text-muted">Zarządzaj lokalizacjami (lokalami)</p>
        </div>
        <a href="/samanta_crm/menu/items" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>Powrót do Menu
        </a>
    </div>

    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <i class="fas fa-check-circle me-2"></i><?= $_SESSION['success']; unset($_SESSION['success']); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="fas fa-exclamation-circle me-2"></i><?= $_SESSION['error']; unset($_SESSION['error']); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <!-- Add New Location -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-plus me-2"></i>Dodaj Lokalizację</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="/samanta_crm/menu/locations/store">
                        <div class="mb-3">
                            <label class="form-label"><span class="text-danger">*</span> Nazwa</label>
                            <input type="text" name="name" class="form-control" placeholder="Krupówki 4a" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Adres</label>
                            <textarea name="address" class="form-control" rows="2" placeholder="ul. Krupówki 4a, 34-500 Zakopane"></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Telefon</label>
                            <input type="text" name="phone" class="form-control" placeholder="+48 123 456 789">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Kolejność</label>
                            <input type="number" name="display_order" class="form-control" value="0">
                        </div>
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" name="is_active" id="new_is_active" checked>
                            <label class="form-check-label" for="new_is_active">Aktywna</label>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-save me-2"></i>Dodaj Lokalizację
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Locations List -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Lista Lokalizacji</h5>
                </div>
                <div class="card-body">
                    <?php if (empty($locations)): ?>
                        <div class="text-center py-4 text-muted">
                            <i class="fas fa-map-marked-alt fa-3x mb-3 d-block"></i>
                            Brak lokalizacji
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th width="60">Kolejn.</th>
                                        <th>Nazwa</th>
                                        <th>Kontakt</th>
                                        <th width="100">Status</th>
                                        <th width="100">Akcje</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($locations as $location): ?>
                                        <tr>
                                            <td><span class="badge bg-light text-dark"><?= $location['display_order'] ?></span></td>
                                            <td>
                                                <strong><i class="fas fa-map-marker-alt text-primary me-2"></i><?= htmlspecialchars($location['name']) ?></strong>
                                                <?php if ($location['address']): ?>
                                                    <br><small class="text-muted"><?= htmlspecialchars($location['address']) ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($location['phone']): ?>
                                                    <small><i class="fas fa-phone me-1"></i><?= htmlspecialchars($location['phone']) ?></small>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($location['is_active']): ?>
                                                    <span class="badge bg-success">Aktywna</span>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary">Nieaktywna</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <button type="button" class="btn btn-outline-primary" onclick="editLocation(<?= htmlspecialchars(json_encode($location)) ?>)">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-outline-danger" onclick="deleteLocation(<?= $location['id'] ?>)">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Location Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-edit me-2"></i>Edytuj Lokalizację</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" id="editForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><span class="text-danger">*</span> Nazwa</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Adres</label>
                        <textarea name="address" id="edit_address" class="form-control" rows="2"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Telefon</label>
                        <input type="text" name="phone" id="edit_phone" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kolejność</label>
                        <input type="number" name="display_order" id="edit_order" class="form-control">
                    </div>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_active" id="edit_is_active">
                        <label class="form-check-label" for="edit_is_active">Aktywna</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Anuluj</button>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Zapisz</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
let editModal;

document.addEventListener('DOMContentLoaded', function() {
    editModal = new bootstrap.Modal(document.getElementById('editModal'));
});

function editLocation(location) {
    document.getElementById('edit_name').value = location.name;
    document.getElementById('edit_address').value = location.address || '';
    document.getElementById('edit_phone').value = location.phone || '';
    document.getElementById('edit_order').value = location.display_order;
    document.getElementById('edit_is_active').checked = location.is_active == 1;
    document.getElementById('editForm').action = '/samanta_crm/menu/locations/' + location.id + '/update';
    editModal.show();
}

function deleteLocation(id) {
    if (confirm('Czy na pewno chcesz usunąć tę lokalizację?\n\nUWAGA: Spowoduje to usunięcie powiązań z pozycjami menu.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '/samanta_crm/menu/locations/' + id + '/delete';
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
