<div class="container-fluid py-4">
    <div class="mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/samanta_crm/menu/items">Menu</a></li>
                <li class="breadcrumb-item active">Edytuj Pozycję</li>
            </ol>
        </nav>
        <h2><i class="fas fa-edit me-2"></i>Edytuj Pozycję Menu</h2>
    </div>

    <form method="POST" action="/samanta_crm/menu/items/<?= $item['id'] ?>/update" enctype="multipart/form-data">
        <div class="row">
            <div class="col-lg-8">
                <!-- Basic Info -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Podstawowe Informacje</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Kod</label>
                                <input type="text" name="code" class="form-control" value="<?= htmlspecialchars($item['code'] ?? '') ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Kategoria</label>
                                <select name="menu_category_id" class="form-select">
                                    <option value="">-- Wybierz kategorię --</option>
                                    <?php foreach ($categories as $cat): ?>
                                        <option value="<?= $cat['id'] ?>" <?= $item['menu_category_id'] == $cat['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($cat['name']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label"><span class="text-danger">*</span> Nazwa (PL)</label>
                                <input type="text" name="name_pl" class="form-control" value="<?= htmlspecialchars($item['name_pl']) ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Name (EN)</label>
                                <input type="text" name="name_en" class="form-control" value="<?= htmlspecialchars($item['name_en'] ?? '') ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Po nazwie (PL)</label>
                                <input type="text" name="after_name_pl" class="form-control" value="<?= htmlspecialchars($item['after_name_pl'] ?? '') ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">After name (EN)</label>
                                <input type="text" name="after_name_en" class="form-control" value="<?= htmlspecialchars($item['after_name_en'] ?? '') ?>">
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Opis (PL)</label>
                                <textarea name="description_pl" class="form-control" rows="3"><?= htmlspecialchars($item['description_pl'] ?? '') ?></textarea>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Description (EN)</label>
                                <textarea name="description_en" class="form-control" rows="3"><?= htmlspecialchars($item['description_en'] ?? '') ?></textarea>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Zdjęcie</label>
                                <?php if ($item['image_url']): ?>
                                    <div class="mb-2">
                                        <img src="<?= htmlspecialchars($item['image_url']) ?>" alt="Aktualne zdjęcie" class="img-thumbnail" style="max-height: 150px;">
                                        <div class="form-text">Aktualne zdjęcie</div>
                                    </div>
                                <?php endif; ?>
                                <input type="file" name="image" class="form-control" accept="image/*">
                                <small class="text-muted">Dozwolone formaty: JPG, PNG, GIF, WEBP (max 5MB). Pozostaw puste, aby zachować obecne zdjęcie.</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Prices -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Ceny</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <!-- Price 1 -->
                            <div class="col-md-4">
                                <label class="form-label">Cena 1 - Prefix (PL)</label>
                                <input type="text" name="price_1_prefix_pl" class="form-control" value="<?= htmlspecialchars($item['price_1_prefix_pl'] ?? '') ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Cena 1</label>
                                <input type="number" step="0.01" name="price_1" class="form-control" value="<?= $item['price_1'] ?? '' ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Price 1 - Prefix (EN)</label>
                                <input type="text" name="price_1_prefix_en" class="form-control" value="<?= htmlspecialchars($item['price_1_prefix_en'] ?? '') ?>">
                            </div>

                            <!-- Price 2 -->
                            <div class="col-md-4">
                                <label class="form-label">Cena 2 - Prefix (PL)</label>
                                <input type="text" name="price_2_prefix_pl" class="form-control" value="<?= htmlspecialchars($item['price_2_prefix_pl'] ?? '') ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Cena 2</label>
                                <input type="number" step="0.01" name="price_2" class="form-control" value="<?= $item['price_2'] ?? '' ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Price 2 - Prefix (EN)</label>
                                <input type="text" name="price_2_prefix_en" class="form-control" value="<?= htmlspecialchars($item['price_2_prefix_en'] ?? '') ?>">
                            </div>

                            <!-- Price 3 -->
                            <div class="col-md-4">
                                <label class="form-label">Cena 3 - Prefix (PL)</label>
                                <input type="text" name="price_3_prefix_pl" class="form-control" value="<?= htmlspecialchars($item['price_3_prefix_pl'] ?? '') ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Cena 3</label>
                                <input type="number" step="0.01" name="price_3" class="form-control" value="<?= $item['price_3'] ?? '' ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Price 3 - Prefix (EN)</label>
                                <input type="text" name="price_3_prefix_en" class="form-control" value="<?= htmlspecialchars($item['price_3_prefix_en'] ?? '') ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <!-- Locations -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Lokalizacje</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted small mb-3">Zaznacz lokale, w których ta pozycja jest dostępna:</p>
                        <?php foreach ($locations as $location): ?>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="locations[]" 
                                       value="<?= $location['id'] ?>" 
                                       id="loc_<?= $location['id'] ?>"
                                       <?= in_array($location['id'], $selectedLocations) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="loc_<?= $location['id'] ?>">
                                    <i class="fas fa-map-marker-alt text-primary me-1"></i>
                                    <?= htmlspecialchars($location['name']) ?>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Display Settings -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Ustawienia Wyświetlania</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Kolejność</label>
                            <input type="number" step="0.1" name="display_order" class="form-control" value="<?= $item['display_order'] ?>">
                            <small class="text-muted">Kolejność sortowania (np. 1053.1)</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Rozmiar Czcionki</label>
                            <input type="text" name="font_size" class="form-control" value="<?= htmlspecialchars($item['font_size'] ?? '') ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Własne CSS</label>
                            <textarea name="custom_css" class="form-control" rows="2"><?= htmlspecialchars($item['custom_css'] ?? '') ?></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Styl Ramki</label>
                            <input type="text" name="border_style" class="form-control" value="<?= htmlspecialchars($item['border_style'] ?? '') ?>">
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= $item['is_active'] ? 'checked' : '' ?>>
                            <label class="form-check-label" for="is_active">Aktywna</label>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="card">
                    <div class="card-body">
                        <button type="submit" class="btn btn-primary w-100 mb-2">
                            <i class="fas fa-save me-2"></i>Zapisz Zmiany
                        </button>
                        <a href="/samanta_crm/menu/items" class="btn btn-secondary w-100">
                            <i class="fas fa-times me-2"></i>Anuluj
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
