<?php $title='Edytuj Kategorię Menu'; ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2><i class="fas fa-edit me-2"></i>Edytuj Kategorię Menu</h2>
        <p class="text-muted">Edytuj kategorię menu lokali</p>
    </div>
    <a href="/samanta_crm/menu/categories" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-2"></i>Powrót do Kategorii
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="/samanta_crm/menu/categories/<?= $category['id'] ?>/update">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Nazwa (PL) *</label>
                        <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($category['name']) ?>" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Name (EN)</label>
                        <input type="text" name="name_en" class="form-control" value="<?= htmlspecialchars($category['name_en'] ?? '') ?>">
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Opis (PL)</label>
                        <textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($category['description'] ?? '') ?></textarea>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Description (EN)</label>
                        <textarea name="description_en" class="form-control" rows="3"><?= htmlspecialchars($category['description_en'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">Kolejność sortowania</label>
                <input type="number" name="sort_order" class="form-control" value="<?= $category['sort_order'] ?>" min="0">
                <small class="text-muted">Mniejsza liczba = wyższa pozycja na liście</small>
            </div>
            
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Zapisz zmiany
                </button>
                <a href="/samanta_crm/menu/categories" class="btn btn-secondary">
                    Anuluj
                </a>
            </div>
        </form>
    </div>
</div>

<?php $content=ob_get_clean(); require '../app/Views/layout.php'; ?>
