<?php
// Ensure translation helper is available
require_once __DIR__ . '/../helpers/translation.php';
?>
<!DOCTYPE html>
<html lang="<?= Translation::getCurrentLanguage() ?>" dir="<?= getTextDirection() ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php 
    $settingPath = __DIR__ . '/../Models/Setting.php';
    if (file_exists($settingPath)) {
        require_once $settingPath; 
    }
    ?>
    <?php $siteName = get_setting('site_name', __('app.name')); ?>
    <title><?= isset($title) && $title ? $siteName . ' - ' . htmlspecialchars($title) : $siteName ?></title>
    <link rel="icon" type="image/png" href="/samanta_crm/public/assets/images/png/favicon.png">
    <link rel="apple-touch-icon" href="/samanta_crm/public/assets/images/png/favicon.png">
    <link href="/samanta_crm/public/assets/fonts/noto-color-emoji.css" rel="stylesheet">
   <!-- <link href="/samanta_crm/public/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet"> -->
    <link href="https://cdn.jsdelivr.net/npm/bootswatch@5.3.8/dist/pulse/bootstrap.min.css" rel="stylesheet">
    <link href="/samanta_crm/public/assets/vendor/fontawesome/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet">
    <link href="/samanta_crm/public/assets/css/app.css" rel="stylesheet">
    <style>
        body {
            overflow-x: hidden;
        }

        #sidebar-wrapper {
            min-height: 100vh;
            margin-left: -15rem;
            min-width: 15rem;
            transition: margin 0.25s ease-out;
        }

        #sidebar-wrapper .sidebar-heading {
            padding: 0.875rem 1.25rem;
            font-size: 1.2rem;
        }

        #sidebar-wrapper .list-group {
            width: 15rem;
        }

        #page-content-wrapper {
            min-width: 100vw;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        body.sb-sidenav-toggled #sidebar-wrapper {
            margin-left: 0;
        }

        @media (min-width: 768px) {
            #sidebar-wrapper {
                margin-left: 0;
            }

            #page-content-wrapper {
                min-width: 0;
                width: 100%;
            }

            body.sb-sidenav-toggled #sidebar-wrapper {
                margin-left: -15rem;
            }
        }

        /* Sidebar Toggle Styles */
        .btn-toggle {
            padding: .5rem;
            font-weight: 600;
            color: rgba(255, 255, 255, .8);
            background-color: transparent;
            border: 0;
        }
        .btn-toggle:hover,
        .btn-toggle:focus {
            color: rgba(255, 255, 255, 1);
            background-color: rgba(255, 255, 255, .1);
        }
        .btn-toggle::after {
            width: 1.25em;
            line-height: 0;
            content: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='rgba%28255,255,255,.5%29' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M5 14l6-6-6-6'/%3e%3c/svg%3e");
            transition: transform .35s ease;
            transform-origin: .5em 50%;
            margin-left: auto;
        }
        .btn-toggle[aria-expanded="true"] {
            color: rgba(255, 255, 255, 1);
        }
        .btn-toggle[aria-expanded="true"]::after {
            transform: rotate(90deg);
        }
        .btn-toggle-nav a {
            padding: .1875rem .5rem;
            margin-top: .125rem;
            margin-left: 1.25rem;
            color: rgba(255, 255, 255, .8);
            text-decoration: none;
        }
        .btn-toggle-nav a:hover,
        .btn-toggle-nav a:focus {
            background-color: rgba(255, 255, 255, .1);
            color: #fff;
        }
    </style>
</head>
<body class="<?php echo (isset($_COOKIE['sb-sidebar-toggle']) && $_COOKIE['sb-sidebar-toggle'] === '1') ? 'sb-sidenav-toggled' : ''; ?>">
    <script>
        // Cookie helper functions
        function setCookie(name, value, days = 365) {
            const expires = new Date(Date.now() + days * 864e5).toUTCString();
            document.cookie = name + '=' + encodeURIComponent(value) + '; expires=' + expires + '; path=/';
        }
        
        function getCookie(name) {
            return document.cookie.split('; ').reduce((r, v) => {
                const parts = v.split('=');
                return parts[0] === name ? decodeURIComponent(parts[1]) : r;
            }, '');
        }
    </script>
    <?php if (isset($_SESSION['user_id'])): ?>
    <div class="d-flex" id="wrapper">
        <!-- Sidebar-->
        <div class="bg-dark border-end" id="sidebar-wrapper">
            <div class="sidebar-heading border-bottom bg-primary text-white text-center">
                <?php 
                $logo = get_setting('site_logo',''); 
                $logoExists = false;
                if($logo) {
                    $logoPath = $_SERVER['DOCUMENT_ROOT'] . str_replace('/samanta_crm/public', '/samanta_crm/public', $logo);
                    $logoExists = file_exists($logoPath);
                }
                if($logo && $logoExists): 
                ?>
                    <img src="<?= htmlspecialchars($logo) ?>" alt="Logo" class="me-2" style="max-height: 80px;" onerror="this.style.display='none';">
                <?php else: ?>
                    <i class="fas fa-birthday-cake" style="font-size: 3rem;"></i>
                <?php endif; ?>
               
            </div><div class="d-lg-none d-md-flex d-flex" style="scale: .7">
                    <?php require __DIR__.'/widgets/clock.php'; ?>
                </div>       
            <?php 
            $uri = $_SERVER['REQUEST_URI']; 
            // Helper to check if a section should be open
            $isCatalogOpen = strpos($uri, '/products') !== false || strpos($uri, '/categories') !== false;
            $isProductionOpen = strpos($uri, '/ingredients') !== false || strpos($uri, '/units') !== false || strpos($uri, '/production-sites') !== false;
            $isOrdersOpen = strpos($uri, '/orders') !== false || strpos($uri, '/customers') !== false || (strpos($uri, '/reports/daily') !== false) || strpos($uri, '/cake-order') !== false;
            $isStockOpen = strpos($uri, '/stock') !== false || strpos($uri, '/restocks') !== false;
            $isReportsOpen = (strpos($uri, '/reports') !== false && strpos($uri, '/reports/daily') === false) || strpos($uri, '/report-flags') !== false;
            $isMenuOpen = strpos($uri, '/menu') !== false || strpos($uri, '/versions') !== false;
            $isAdminOpen = strpos($uri, '/users') !== false || strpos($uri, '/user-types') !== false || strpos($uri, '/languages') !== false || strpos($uri, '/settings') !== false || strpos($uri, '/export') !== false || strpos($uri, '/migration') !== false;
            ?>
            <ul class="list-unstyled ps-0 p-3" id="sidebarMenu">
                <!-- Dashboard -->
                <li class="mb-1">
                    <a href="/samanta_crm/dashboard" class="btn btn-toggle align-items-center rounded text-start w-100 <?= strpos($uri, '/dashboard') !== false ? 'active' : '' ?>">
                        <i class="fas fa-tachometer-alt me-2"></i><?= __('nav.dashboard') ?>
                    </a>
                </li>
                
                <!-- Catalog -->
                <li class="mb-1">
                    <button class="btn btn-toggle align-items-center rounded text-start w-100 <?= $isCatalogOpen ? '' : 'collapsed' ?>" data-bs-toggle="collapse" data-bs-target="#catalogCollapse" aria-expanded="<?= $isCatalogOpen ? 'true' : 'false' ?>">
                        <i class="fas fa-boxes me-2"></i><?= __('nav.catalog', 'Catalog') ?>
                    </button>
                    <div class="collapse <?= $isCatalogOpen ? 'show' : '' ?>" id="catalogCollapse">
                        <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small">
                            <li><a href="/samanta_crm/products" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/products') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-box me-2"></i><?= __('nav.products', 'Products') ?>
                            </a></li>
                            <li><a href="/samanta_crm/categories" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/categories') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-layer-group me-2"></i><?= __('nav.categories', 'Categories') ?>
                            </a></li>
                        </ul>
                    </div>
                </li>
                
                <!-- Production -->
                <li class="mb-1">
                    <button class="btn btn-toggle align-items-center rounded text-start w-100 <?= $isProductionOpen ? '' : 'collapsed' ?>" data-bs-toggle="collapse" data-bs-target="#productionCollapse" aria-expanded="<?= $isProductionOpen ? 'true' : 'false' ?>">
                        <i class="fas fa-industry me-2"></i><?= __('nav.production', 'Production') ?>
                    </button>
                    <div class="collapse <?= $isProductionOpen ? 'show' : '' ?>" id="productionCollapse">
                        <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small">
                            <li><a href="/samanta_crm/ingredients" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/ingredients') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-carrot me-2"></i><?= __('nav.ingredients', 'Ingredients') ?>
                            </a></li>
                            <li><a href="/samanta_crm/units" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/units') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-ruler-combined me-2"></i><?= __('nav.units', 'Units') ?>
                            </a></li>
                            <li><a href="/samanta_crm/production-sites" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/production-sites') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-industry me-2"></i><?= __('nav.production_sites', 'Production Sites') ?>
                            </a></li>
                        </ul>
                    </div>
                </li>
                
                <!-- Orders -->
                <li class="mb-1">
                    <button class="btn btn-toggle align-items-center rounded text-start w-100 <?= $isOrdersOpen ? '' : 'collapsed' ?>" data-bs-toggle="collapse" data-bs-target="#ordersCollapse" aria-expanded="<?= $isOrdersOpen ? 'true' : 'false' ?>">
                        <i class="fas fa-receipt me-2"></i><?= __('nav.orders', 'Orders') ?>
                    </button>
                    <div class="collapse <?= $isOrdersOpen ? 'show' : '' ?>" id="ordersCollapse">
                        <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small">
                            <li><a href="/samanta_crm/orders" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/orders') !== false && strpos($uri, '/orders/panel') === false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-receipt me-2"></i><?= __('nav.orders', 'Orders') ?>
                            </a></li>
                            <li><a href="/samanta_crm/orders/panel" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/orders/panel') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-tablet-alt me-2"></i><?= __('nav.tablet_panel', 'Tablet Panel') ?>
                            </a></li>
                            <li><a href="/samanta_crm/cake-orders" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/cake-orders') !== false || strpos($uri, '/cake-order') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-birthday-cake me-2"></i><?= __('nav.cake_orders', 'Cake Orders') ?>
                            </a></li>
                            <li><a href="/samanta_crm/reports/daily" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/reports/daily') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-calendar-day me-2"></i><?= __('nav.daily_reports', 'Daily Reports') ?>
                            </a></li>
                            <li><a href="/samanta_crm/customers" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/customers') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-user-group me-2"></i><?= __('nav.customers', 'Customers') ?>
                            </a></li>
                        </ul>
                    </div>
                </li>
                
                <!-- Stock -->
                <li class="mb-1">
                    <button class="btn btn-toggle align-items-center rounded text-start w-100 <?= $isStockOpen ? '' : 'collapsed' ?>" data-bs-toggle="collapse" data-bs-target="#stockCollapse" aria-expanded="<?= $isStockOpen ? 'true' : 'false' ?>">
                        <i class="fas fa-warehouse me-2"></i><?= __('nav.stock', 'Stock') ?>
                    </button>
                    <div class="collapse <?= $isStockOpen ? 'show' : '' ?>" id="stockCollapse">
                        <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small">
                            <li><a href="/samanta_crm/stock/ingredients" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/stock/ingredients') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-cubes me-2"></i><?= __('nav.ingredient_stock', 'Ingredient Stock') ?>
                            </a></li>
                            <li><a href="/samanta_crm/restocks" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/restocks') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-truck-loading me-2"></i><?= __('nav.restocks', 'Restocks') ?>
                            </a></li>
                            <li><a href="/samanta_crm/stock/usage-history" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/stock/usage-history') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-history me-2"></i><?= __('nav.usage_history', 'Usage History') ?>
                            </a></li>
                            <li><a href="/samanta_crm/stock/usage-chart" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/stock/usage-chart') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-chart-line me-2"></i><?= __('nav.usage_chart', 'Usage Chart') ?>
                            </a></li>
                            <li><a href="/samanta_crm/stock/daily-usage" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/stock/daily-usage') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-calendar-check me-2"></i><?= __('nav.daily_usage', 'Daily Usage') ?>
                            </a></li>
                        </ul>
                    </div>
                </li>
                
                <!-- Reports -->
                <li class="mb-1">
                    <button class="btn btn-toggle align-items-center rounded text-start w-100 <?= $isReportsOpen ? '' : 'collapsed' ?>" data-bs-toggle="collapse" data-bs-target="#reportsCollapse" aria-expanded="<?= $isReportsOpen ? 'true' : 'false' ?>">
                        <i class="fas fa-chart-bar me-2"></i><?= __('nav.reports', 'Reports') ?>
                    </button>
                    <div class="collapse <?= $isReportsOpen ? 'show' : '' ?>" id="reportsCollapse">
                        <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small">
                            <li><a href="/samanta_crm/reports" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/reports') !== false && strpos($uri, '/reports/daily') === false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-chart-line me-2"></i><?= __('nav.reports', 'Reports') ?>
                            </a></li>
                            <li><a href="/samanta_crm/report-flags" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/report-flags') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-flag me-2"></i><?= __('nav.report_flags', 'Report Flags') ?>
                            </a></li>
                        </ul>
                    </div>
                </li>
                
                <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
                <!-- Menu Lokali -->
                <li class="mb-1">
                    <button class="btn btn-toggle align-items-center rounded text-start w-100 <?= $isMenuOpen ? '' : 'collapsed' ?>" data-bs-toggle="collapse" data-bs-target="#menuCollapse" aria-expanded="<?= $isMenuOpen ? 'true' : 'false' ?>">
                        <i class="fas fa-utensils me-2"></i>Menu Lokali
                    </button>
                    <div class="collapse <?= $isMenuOpen ? 'show' : '' ?>" id="menuCollapse">
                        <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small">
                            <li><a href="/samanta_crm/menu/items" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/menu/items') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-utensils me-2"></i>Menu Lokali
                            </a></li>
                            <li><a href="/samanta_crm/menu/categories" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/menu/categories') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-layer-group me-2"></i>Kategorie Menu
                            </a></li>
                            <li><a href="/samanta_crm/menu/locations" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/menu/locations') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-map-marker-alt me-2"></i>Lokalizacje
                            </a></li>
                            <li><a href="/samanta_crm/menu/versions" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/versions') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-code-branch me-2"></i><?= __('nav.versions', 'Versions') ?>
                            </a></li>
                        </ul>
                    </div>
                </li>
                
                <!-- Admin -->
                <li class="mb-1">
                    <button class="btn btn-toggle align-items-center rounded text-start w-100 <?= $isAdminOpen ? '' : 'collapsed' ?>" data-bs-toggle="collapse" data-bs-target="#adminCollapse" aria-expanded="<?= $isAdminOpen ? 'true' : 'false' ?>">
                        <i class="fas fa-cogs me-2"></i><?= __('nav.admin') ?>
                    </button>
                    <div class="collapse <?= $isAdminOpen ? 'show' : '' ?>" id="adminCollapse">
                        <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small">
                            <li><a href="/samanta_crm/users" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/users') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-users me-2"></i><?= __('nav.users') ?>
                            </a></li>
                            <li><a href="/samanta_crm/user-types" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/user-types') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-tags me-2"></i><?= __('nav.user_types') ?>
                            </a></li>
                            <li><a href="/samanta_crm/languages" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/languages') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-language me-2"></i><?= __('nav.languages') ?>
                            </a></li>
                            <li><a href="/samanta_crm/settings" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/settings') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-sliders-h me-2"></i><?= __('nav.settings', 'Settings') ?>
                            </a></li>
                            <li><a href="/samanta_crm/export" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/export') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-file-export me-2"></i><?= __('nav.export_import', 'Export / Import') ?>
                            </a></li>
                            <li><a href="/samanta_crm/migration" class="link-light rounded d-block p-2 ps-4 <?= strpos($uri, '/migration') !== false ? 'bg-white text-dark' : '' ?>">
                                <i class="fas fa-file-import me-2"></i>Migracja Zamówień
                            </a></li>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>
            </ul>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="" id="navbarSupportedContent">
                        
                        <ul class="navbar-nav ms-auto mt-2 mt-lg-0">
                            <!-- Language Switcher -->
                            <li class="list-group-item list-group-item-action p-3">
                                <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                    <?php 
                                    $currentLang = getCurrentLanguage();
                                    if ($currentLang && $currentLang['flag']) {
                                        echo $currentLang['flag'] . ' ';
                                    } else {
                                        echo '<i class="fas fa-globe me-1"></i> ';
                                    }
                                    echo $currentLang ? strtoupper($currentLang['code']) : 'EN';
                                    ?>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <?php foreach (getAvailableLanguages() as $lang): ?>
                                    <li>
                                        <a class="dropdown-item" href="#" onclick="switchLanguage('<?= $lang['code'] ?>')">
                                            <?php if ($lang['flag']): ?>
                                                <?= $lang['flag'] ?> 
                                            <?php endif; ?>
                                            &nbsp;<?= htmlspecialchars($lang['native_name'] ?: $lang['name']) ?>
                                        </a>
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                            </li>
                            
                            <!-- User Menu -->
                            <li class="list-group-item list-group-item-action p-3">
                                <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                    <i class="fas fa-user me-1"></i><?= $_SESSION['user_name'] ?? 'User' ?>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li><a class="dropdown-item" href="/samanta_crm/logout">
                                        <i class="fas fa-sign-out-alt me-1"></i><?= __('nav.logout') ?>
                                    </a></li>
                                </ul>
                            </li>
                        </ul>
                    </div>
        </div>
        <!-- Page content wrapper-->
        <div id="page-content-wrapper">
            <!-- Top navigation-->
            <nav class="navbar navbar-expand-lg navbar-light bg-primary-subtle  border-bottom">
                <div class="container-fluid">
                    <button class="btn btn-primary" id="sidebarToggle"><i class="fas fa-bars"></i></button>
                     

                    <span>    
                        <a href="/samanta_crm/orders/create" class="btn btn-primary btn-sm"><i class="fas fa-plus  me-1"></i> <?= __('orders.new_order', 'New Order') ?></a>
                        
                        <a href="/samanta_crm/reports/daily" class="btn btn-secondary btn-sm"><i class="fas fa-calendar-day me-1"></i> <?= __('reports.daily', 'Daily Reports') ?></a>
                    </span>
               

                <div class="d-lg-flex d-md-none d-none">
                    <?php require __DIR__.'/widgets/clock.php'; ?>
                </div>                                    


                </div>
            </nav>
            <!-- Page content-->
            <?php if(isset($fullWidthLayout) && $fullWidthLayout): ?>
                <div class="p-0 flex-grow-1">
                    <?php if (isset($_SESSION['success'])): ?>
                        <div class="alert alert-success alert-dismissible fade show m-3" role="alert">
                            <?= $_SESSION['success'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['success']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show m-3" role="alert">
                            <?= $_SESSION['error'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['error']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['warning'])): ?>
                        <div class="alert alert-warning alert-dismissible fade show m-3" role="alert">
                            <?= $_SESSION['warning'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['warning']); ?>
                    <?php endif; ?>
                    
                    <?= $content ?? '' ?>
                </div>
            <?php else: ?>
            <div class="container-fluid p-3 p-lg-5 flex-grow-1">
                <?php if (isset($_SESSION['success'])): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= $_SESSION['success'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php unset($_SESSION['success']); ?>
                <?php endif; ?>

                <?php if (isset($_SESSION['error'])): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= $_SESSION['error'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php unset($_SESSION['error']); ?>
                <?php endif; ?>

                <?php if (isset($_SESSION['warning'])): ?>
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <?= $_SESSION['warning'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php unset($_SESSION['warning']); ?>
                <?php endif; ?>

                <?= $content ?? '' ?>
            
                <!-- Footer -->
               
            </div>
            <?php endif; ?>
             <footer class="mt-auto py-3 bg-light border-top small">
                    <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
                        <span class="text-muted">&copy; <?= date('Y') ?> <?= __('footer.copyright', 'MyBakeryOS') ?></span>
                        <span class="text-muted"><?= __('footer.created_by', 'Created by') ?> <a href="https://nowagancy.pl" target="_blank" rel="noopener" class="text-decoration-none">nowagancy.pl</a></span>
                    </div>
                </footer>
        </div>
    </div>
    <?php else: ?>
    <main class="">
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= $_SESSION['success'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['success']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= $_SESSION['error'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['error']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['warning'])): ?>
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                <?= $_SESSION['warning'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['warning']); ?>
        <?php endif; ?>

        <?= $content ?? '' ?>
    </main>
    <?php endif; ?>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="/samanta_crm/public/assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="/samanta_crm/public/assets/js/app.js"></script>
    <script>
    // Sidebar toggle functionality
    window.addEventListener('DOMContentLoaded', event => {
        const sidebarToggle = document.body.querySelector('#sidebarToggle');
        if (sidebarToggle) {
            sidebarToggle.addEventListener('click', event => {
                event.preventDefault();
                document.body.classList.toggle('sb-sidenav-toggled');
                setCookie('sb-sidebar-toggle', document.body.classList.contains('sb-sidenav-toggled') ? '1' : '0');
            });
        }
    });
    
    function switchLanguage(langCode) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '/samanta_crm/switch-language';
        
        const langInput = document.createElement('input');
        langInput.type = 'hidden';
        langInput.name = 'language';
        langInput.value = langCode;
        
        const redirectInput = document.createElement('input');
        redirectInput.type = 'hidden';
        redirectInput.name = 'redirect';
        redirectInput.value = window.location.pathname;
        
        form.appendChild(langInput);
        form.appendChild(redirectInput);
        document.body.appendChild(form);
        form.submit();
    }
    </script>
    <?= $scripts ?? '' ?>
</body>
</html>


