<?php 
$title = __('languages.edit', 'Edit Language');
ob_start(); 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-language"></i> <?= __('languages.edit_language', 'Edit Language') ?>: 
        <span class="badge bg-primary"><?= htmlspecialchars($language['name']) ?></span>
    </h1>
    <div>
        <a href="/samanta_crm/languages" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-edit me-1"></i><?= __('languages.language_details', 'Language Details') ?></span>
    </div>
    <div class="card-body">
        <form method="POST" action="/samanta_crm/languages/<?= $language['id'] ?>/update" id="languageForm">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="code" class="form-label"><?= __('languages.language_code', 'Language Code') ?></label>
                        <input type="text" 
                               class="form-control" 
                               id="code" 
                               name="code" 
                               value="<?= htmlspecialchars($language['code']) ?>"
                               readonly>
                        <div class="form-text"><?= __('languages.code_readonly', 'Language code cannot be changed') ?></div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name" class="form-label"><?= __('common.name', 'Name') ?> *</label>
                        <input type="text" 
                               class="form-control" 
                               id="name" 
                               name="name" 
                               value="<?= htmlspecialchars($language['name']) ?>"
                               required>
                        <div class="form-text"><?= __('languages.name_help', 'Language name in English') ?></div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="native_name" class="form-label"><?= __('languages.native_name', 'Native Name') ?></label>
                        <input type="text" 
                               class="form-control" 
                               id="native_name" 
                               name="native_name"
                               value="<?= htmlspecialchars($language['native_name']) ?>">
                        <div class="form-text"><?= __('languages.native_name_help', 'Language name in its own language') ?></div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="flag" class="form-label"><?= __('languages.flag', 'Flag') ?></label>
                        <input type="text" 
                               class="form-control" 
                               id="flag" 
                               name="flag" 
                               maxlength="10"
                               value="<?= htmlspecialchars($language['flag']) ?>">
                        <div class="form-text"><?= __('languages.flag_help', 'Flag emoji or symbol') ?></div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-check mb-3">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="is_active" 
                               name="is_active" 
                               value="1"
                               <?= $language['is_active'] ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_active">
                            <?= __('common.active', 'Active') ?>
                        </label>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-check mb-3">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="is_default" 
                               name="is_default" 
                               value="1"
                               <?= $language['is_default'] ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_default">
                            <?= __('languages.default_language', 'Default Language') ?>
                        </label>
                        <div class="form-text"><?= __('languages.default_help', 'Set as default language (will unset current default)') ?></div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="languageForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __('languages.update_language', 'Update Language') ?>
        </button>
        <a href="/samanta_crm/languages" class="btn btn-secondary">
            <?= __('common.cancel', 'Cancel') ?>
        </a>
    </div>
</div>

<div class="card mt-3">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-info-circle me-1"></i><?= __('languages.language_info', 'Language Information') ?></span>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-4">
                <p class="mb-2"><strong>ID:</strong> <?= $language['id'] ?></p>
            </div>
            <div class="col-md-4">
                <p class="mb-2"><strong><?= __('common.created', 'Created') ?>:</strong> <?= date('M j, Y g:i A', strtotime($language['created_at'])) ?></p>
            </div>
            <?php if ($language['updated_at']): ?>
            <div class="col-md-4">
                <p class="mb-2"><strong><?= __('common.last_updated', 'Last Updated') ?>:</strong> <?= date('M j, Y g:i A', strtotime($language['updated_at'])) ?></p>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="card-footer py-2">
        <a href="/samanta_crm/languages/<?= $language['id'] ?>/translations" class="btn btn-primary">
            <i class="fas fa-language me-1"></i><?= __('languages.manage_translations', 'Manage Translations') ?>
        </a>
    </div>
</div>

<?php 
$content = ob_get_clean();
include '../app/Views/layout.php'; 
?>
  

