<?php $title=__('ingredients.title', 'Ingredients'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-carrot"></i> <?= __('ingredients.title', 'Ingredients') ?>
    </h1>
    <div class="btn-group">
        <a href="/samanta_crm/ingredients/create" class="btn btn-primary">
            <i class="fas fa-plus"></i> <?= __('common.add', 'Add') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2 d-flex justify-content-between align-items-center">
        <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('ingredients.title', 'Ingredients') ?></span>
    </div>
    <div class="card-body pt-0">
        <div class="table-responsive">
            <table class="table table-sm table-hover align-middle data-table mb-0" id="ingredientsTable">
                <thead class="table-light">
                    <tr>
                        <th><?= __("common.name", "Name") ?></th>
                        <th class="d-none d-md-table-cell"><?= __("common.unit", "Unit") ?></th>
                        <th class="d-none d-lg-table-cell"><?= __("ingredients.supplier", "Supplier") ?></th>
                        <th class="text-end"><?= __("common.actions", "Actions") ?></th>
                    </tr>
                </thead>
            <tbody>
                <?php foreach($ingredients as $c): ?>
                    <?php $code=$c['unit']; $unitLabel = $code && isset($unitsMap[$code]) ? ($unitsMap[$code]['name'].' ('.$code.')') : htmlspecialchars($code); ?>
                    <tr>
                        <td>
                            <strong class="small"><?= htmlspecialchars($c['name']) ?></strong>
                            <!-- Mobile-only info (phones) -->
                            <div class="d-md-none small text-muted mt-1">
                                <i class="fas fa-balance-scale me-1"></i><?= $unitLabel ?>
                            </div>
                            <!-- Tablet-only info (tablets but not desktop) -->
                            <?php if(!empty($c['supplier'])): ?>
                            <div class="d-lg-none d-none d-md-block small text-muted mt-1">
                                <i class="fas fa-truck me-1"></i><?= htmlspecialchars($c['supplier']) ?>
                            </div>
                            <?php endif; ?>
                        </td>
                        <td class="d-none d-md-table-cell"><?= $unitLabel ?></td>
                        <td class="text-muted d-none d-lg-table-cell"><?= htmlspecialchars($c['supplier'] ?? '') ?></td>
                        <td class="text-end">
                            <div class="btn-group btn-group-sm">
                                <a class="btn btn-outline-primary" href="/samanta_crm/ingredients/<?= $c['id'] ?>/edit">
                                    <i class="fas fa-edit"></i><span class="d-none d-sm-inline ms-1"><?= __("common.edit", "Edit") ?></span>
                                </a>
                                <form method="POST" action="/samanta_crm/ingredients/<?= $c['id'] ?>/delete" class="d-inline" onsubmit="return confirm('<?= __("common.confirm_delete", "Delete?") ?>')">
                                    <button class="btn btn-outline-danger">
                                        <i class="fas fa-trash"></i><span class="d-none d-sm-inline ms-1"><?= __("common.delete", "Del") ?></span>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span></span>
        <div class="small text-muted">
            <?= __('common.total', 'Total') ?>: <?= count($ingredients) ?> <?= __('common.items', 'items') ?>
        </div>
    </div>
</div>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>


