<?php $title=__('ingredients.add_ingredient', 'Add Ingredient'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-carrot"></i> <?= __('ingredients.add_ingredient', 'Add Ingredient') ?>
    </h1>
    <div>
        <a href="/samanta_crm/ingredients" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-plus me-1"></i><?= __('ingredients.ingredient_details', 'Ingredient Details') ?></span>
    </div>
    <div class="card-body">
        <form method="POST" action="/samanta_crm/ingredients" id="ingredientForm">
            <div class="mb-3">
                <label class="form-label"><?= __('common.name', 'Name') ?> *</label>
                <input name="name" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.unit', 'Unit') ?></label>
                <select name="unit_code" class="form-select">
                    <option value=""><?= __('common.none', '-- None --') ?></option>
                    <?php foreach(($units??[]) as $u): ?>
                        <option value="<?= htmlspecialchars($u['code']) ?>"><?= htmlspecialchars($u['name']) ?> (<?= htmlspecialchars($u['code']) ?>)</option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('ingredients.supplier', 'Supplier') ?></label>
                <input name="supplier" class="form-control" placeholder="<?= __('ingredients.supplier_placeholder', 'Supplier name') ?>">
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('ingredients.notes', 'Notes') ?></label>
                <textarea name="notes" class="form-control" rows="3"></textarea>
            </div>
            
            <div class="card mb-3 border">
                <div class="card-header py-2 small fw-bold bg-light">
                    <i class="fas fa-exclamation-triangle me-1"></i><?= __('ingredients.stock_levels', 'Stock Level Alerts') ?>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label"><?= __('ingredients.critical_low_stock', 'Critical Low Stock') ?></label>
                            <input type="number" step="0.01" name="critical_low_stock" class="form-control" placeholder="<?= __('ingredients.critical_low_hint', 'Alert when below this level') ?>">
                            <div class="form-text"><?= __('ingredients.critical_low_desc', 'Urgent restock needed') ?></div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label"><?= __('ingredients.low_stock', 'Low Stock') ?></label>
                            <input type="number" step="0.01" name="low_stock" class="form-control" placeholder="<?= __('ingredients.low_stock_hint', 'Warning level') ?>">
                            <div class="form-text"><?= __('ingredients.low_stock_desc', 'Should restock soon') ?></div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label"><?= __('ingredients.high_stock', 'High Stock') ?></label>
                            <input type="number" step="0.01" name="high_stock" class="form-control" placeholder="<?= __('ingredients.high_stock_hint', 'Warning level') ?>">
                            <div class="form-text"><?= __('ingredients.high_stock_desc', 'Stock above normal') ?></div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label"><?= __('ingredients.critical_high_stock', 'Critical High Stock') ?></label>
                            <input type="number" step="0.01" name="critical_high_stock" class="form-control" placeholder="<?= __('ingredients.critical_high_hint', 'Alert when above this level') ?>">
                            <div class="form-text"><?= __('ingredients.critical_high_desc', 'Overstocked - risk of waste') ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="ingredientForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __('common.save', 'Save') ?>
        </button>
        <a href="/samanta_crm/ingredients" class="btn btn-secondary">
            <?= __('common.cancel', 'Cancel') ?>
        </a>
    </div>
</div>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>


