<?php
// Cake order view - document/invoice style
$cakeDetails = $cakeDetailsModel->findByOrderId($order['id']);
$customer = $customerModel->find($order['customer_id']);
$flavor = $cakeDetails && $cakeDetails['flavor_id'] ? $flavorModel->find($cakeDetails['flavor_id']) : null;
$size = $cakeDetails && $cakeDetails['size_id'] ? $sizeModel->find($cakeDetails['size_id']) : null;
$location = $order['pickup_location_id'] ? $locationModel->find($order['pickup_location_id']) : null;

// Get cake types
$cakeTypeNames = [];
if ($cakeDetails && !empty($cakeDetails['cake_type_ids'])) {
    $typeIds = explode(',', $cakeDetails['cake_type_ids']);
    foreach ($typeIds as $typeId) {
        $type = $typeModel->find(trim($typeId));
        if ($type) {
            $cakeTypeNames[] = $type['name'];
        }
    }
}
?>

<style>
    @media print {
        .no-print { display: none !important; }
        .cake-order-document { box-shadow: none !important; border: 1px solid #dee2e6 !important; }
    }
    
    .cake-order-document {
        background: white;
        max-width: 800px;
        margin: 0 auto;
        padding: 40px;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
        border: 1px solid #dee2e6;
    }
    
    .order-header {
        border-bottom: 3px solid #667eea;
        padding-bottom: 20px;
        margin-bottom: 30px;
    }
    
    .order-number {
        font-size: 2rem;
        font-weight: bold;
        color: #667eea;
    }
    
    .section-title {
        background: #f8f9fa;
        padding: 10px 15px;
        border-left: 4px solid #667eea;
        margin: 25px 0 15px 0;
        font-weight: 600;
        font-size: 1.1rem;
    }
    
    .detail-row {
        display: flex;
        padding: 8px 0;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .detail-label {
        font-weight: 600;
        color: #6c757d;
        width: 200px;
        flex-shrink: 0;
    }
    
    .detail-value {
        flex: 1;
        color: #212529;
    }
    
    .cake-icon {
        font-size: 3rem;
        color: #667eea;
    }
    
    .price-summary {
        background: #f8f9fa;
        border: 2px solid #667eea;
        border-radius: 8px;
        padding: 20px;
        margin-top: 30px;
    }
    
    .price-row {
        display: flex;
        justify-content: space-between;
        padding: 8px 0;
        font-size: 1.1rem;
    }
    
    .price-total {
        border-top: 2px solid #667eea;
        margin-top: 10px;
        padding-top: 10px;
        font-weight: bold;
        font-size: 1.3rem;
        color: #667eea;
    }
    
    .status-badge-large {
        display: inline-block;
        padding: 8px 20px;
        border-radius: 20px;
        font-weight: 600;
        font-size: 1rem;
    }
    
    .decoration-item {
        background: #fff;
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        padding: 12px;
        margin: 8px 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .decoration-icon {
        font-size: 1.5rem;
        color: #667eea;
        width: 40px;
        text-align: center;
    }
</style>

<div class="content">
    <div class="no-print mb-4">
        <div class="d-flex justify-content-between align-items-center">
            <h2><i class="fas fa-birthday-cake me-2"></i>Cake Order Details</h2>
            <div>
                <button onclick="window.print()" class="btn btn-primary">
                    <i class="fas fa-print me-1"></i>Print
                </button>
                <a href="<?= url('cake-orders') ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i>Back to List
                </a>
            </div>
        </div>
    </div>

    <div class="cake-order-document">
        <!-- Header -->
        <div class="order-header">
            <div class="row">
                <div class="col-8">
                    <div class="order-number">ORDER #<?= $order['id'] ?></div>
                    <div class="text-muted">Cake Order</div>
                </div>
                <div class="col-4 text-end">
                    <div class="cake-icon">
                        <i class="fas fa-birthday-cake"></i>
                    </div>
                </div>
            </div>
            <div class="mt-3">
                <?php
                $statusClass = match($order['status']) {
                    'pending' => 'bg-warning text-dark',
                    'confirmed' => 'bg-info text-white',
                    'in_progress' => 'bg-primary text-white',
                    'ready' => 'bg-success text-white',
                    'completed' => 'bg-secondary text-white',
                    'cancelled' => 'bg-danger text-white',
                    default => 'bg-secondary text-white'
                };
                ?>
                <span class="status-badge-large <?= $statusClass ?>">
                    <?= ucfirst(str_replace('_', ' ', $order['status'])) ?>
                </span>
            </div>
        </div>

        <!-- Customer Information -->
        <div class="section-title">
            <i class="fas fa-user me-2"></i>Customer Information
        </div>
        <div class="detail-row">
            <div class="detail-label">Name:</div>
            <div class="detail-value"><?= htmlspecialchars(($customer['first_name'] ?? '') . ' ' . ($customer['last_name'] ?? '')) ?></div>
        </div>
        <div class="detail-row">
            <div class="detail-label">Phone:</div>
            <div class="detail-value"><?= htmlspecialchars($customer['phone'] ?? 'N/A') ?></div>
        </div>
        <?php if(!empty($customer['email'])): ?>
        <div class="detail-row">
            <div class="detail-label">Email:</div>
            <div class="detail-value"><?= htmlspecialchars($customer['email']) ?></div>
        </div>
        <?php endif; ?>

        <!-- Pickup Information -->
        <div class="section-title">
            <i class="fas fa-map-marker-alt me-2"></i>Pickup Information
        </div>
        <div class="detail-row">
            <div class="detail-label">Pickup Date:</div>
            <div class="detail-value">
                <strong><?= date('l, F j, Y', strtotime($order['pickup_date'])) ?></strong>
            </div>
        </div>
        <div class="detail-row">
            <div class="detail-label">Pickup Time:</div>
            <div class="detail-value">
                <strong><?= date('H:i', strtotime($order['pickup_time'])) ?></strong>
            </div>
        </div>
        <div class="detail-row">
            <div class="detail-label">Location:</div>
            <div class="detail-value"><?= $location ? htmlspecialchars($location['name']) : 'N/A' ?></div>
        </div>
        <?php if($order['delivery_address']): ?>
        <div class="detail-row">
            <div class="detail-label">Delivery Address:</div>
            <div class="detail-value"><?= nl2br(htmlspecialchars($order['delivery_address'])) ?></div>
        </div>
        <?php endif; ?>

        <!-- Cake Details -->
        <div class="section-title">
            <i class="fas fa-birthday-cake me-2"></i>Cake Specifications
        </div>
        <div class="detail-row">
            <div class="detail-label">Flavor:</div>
            <div class="detail-value">
                <strong><?= $flavor ? htmlspecialchars($flavor['name']) : 'N/A' ?></strong>
                <?php if($cakeDetails && $cakeDetails['flavor_custom']): ?>
                    <div class="text-muted small"><?= htmlspecialchars($cakeDetails['flavor_custom']) ?></div>
                <?php endif; ?>
            </div>
        </div>
        <div class="detail-row">
            <div class="detail-label">Size:</div>
            <div class="detail-value">
                <strong><?= $size ? htmlspecialchars($size['name']) : 'N/A' ?></strong>
                <?php if($cakeDetails && $cakeDetails['size_custom']): ?>
                    <div class="text-muted small"><?= htmlspecialchars($cakeDetails['size_custom']) ?></div>
                <?php endif; ?>
            </div>
        </div>
        <?php if(!empty($cakeTypeNames)): ?>
        <div class="detail-row">
            <div class="detail-label">Type:</div>
            <div class="detail-value">
                <?= implode(', ', array_map('htmlspecialchars', $cakeTypeNames)) ?>
                <?php if($cakeDetails && $cakeDetails['cake_type_custom']): ?>
                    <div class="text-muted small"><?= htmlspecialchars($cakeDetails['cake_type_custom']) ?></div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Decorations -->
        <?php if($cakeDetails): ?>
        <div class="section-title">
            <i class="fas fa-magic me-2"></i>Decorations & Extras
        </div>
        
        <?php if($cakeDetails['has_inscription']): ?>
        <div class="decoration-item">
            <div class="decoration-icon"><i class="fas fa-pen-fancy"></i></div>
            <div class="flex-grow-1">
                <strong>Inscription:</strong> <?= htmlspecialchars($cakeDetails['inscription_text']) ?>
            </div>
            <?php if($cakeDetails['inscription_price'] > 0): ?>
            <div class="text-muted"><?= number_format($cakeDetails['inscription_price'], 2) ?> PLN</div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php if($cakeDetails['has_candles']): ?>
        <div class="decoration-item">
            <div class="decoration-icon"><i class="fas fa-fire"></i></div>
            <div class="flex-grow-1">
                <strong>Candles:</strong> <?= $cakeDetails['candles_count'] ?> pieces
            </div>
            <?php if($cakeDetails['candles_price'] > 0): ?>
            <div class="text-muted"><?= number_format($cakeDetails['candles_price'], 2) ?> PLN</div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php if($cakeDetails['has_number_candle']): ?>
        <div class="decoration-item">
            <div class="decoration-icon"><i class="fas fa-hashtag"></i></div>
            <div class="flex-grow-1">
                <strong>Number Candle:</strong> <?= $cakeDetails['number_candle_value'] ?>
            </div>
            <?php if($cakeDetails['number_candle_price'] > 0): ?>
            <div class="text-muted"><?= number_format($cakeDetails['number_candle_price'], 2) ?> PLN</div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php if($cakeDetails['has_sparkler']): ?>
        <div class="decoration-item">
            <div class="decoration-icon"><i class="fas fa-star"></i></div>
            <div class="flex-grow-1"><strong>Sparkler</strong></div>
            <?php if($cakeDetails['sparkler_price'] > 0): ?>
            <div class="text-muted"><?= number_format($cakeDetails['sparkler_price'], 2) ?> PLN</div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php if($cakeDetails['has_wafer_photo']): ?>
        <div class="decoration-item">
            <div class="decoration-icon"><i class="fas fa-image"></i></div>
            <div class="flex-grow-1">
                <strong>Wafer Photo/Graphic</strong>
                <?php if($cakeDetails['wafer_file']): ?>
                    <div class="text-muted small">
                        <a href="<?= $cakeDetails['wafer_file'] ?>" target="_blank">View file</a>
                    </div>
                <?php endif; ?>
            </div>
            <?php if($cakeDetails['wafer_photo_price'] > 0): ?>
            <div class="text-muted"><?= number_format($cakeDetails['wafer_photo_price'], 2) ?> PLN</div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php if($cakeDetails['has_card']): ?>
        <div class="decoration-item">
            <div class="decoration-icon"><i class="fas fa-envelope"></i></div>
            <div class="flex-grow-1">
                <strong>Card/Note:</strong> <?= htmlspecialchars($cakeDetails['card_text']) ?>
            </div>
            <?php if($cakeDetails['card_price'] > 0): ?>
            <div class="text-muted"><?= number_format($cakeDetails['card_price'], 2) ?> PLN</div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php if($cakeDetails['has_figurine']): ?>
        <div class="decoration-item">
            <div class="decoration-icon"><i class="fas fa-chess-knight"></i></div>
            <div class="flex-grow-1">
                <strong>Figurine:</strong> <?= htmlspecialchars($cakeDetails['figurine_description']) ?>
            </div>
            <?php if($cakeDetails['figurine_price'] > 0): ?>
            <div class="text-muted"><?= number_format($cakeDetails['figurine_price'], 2) ?> PLN</div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php if($cakeDetails['reference_photo']): ?>
        <div class="decoration-item">
            <div class="decoration-icon"><i class="fas fa-camera"></i></div>
            <div class="flex-grow-1">
                <strong>Reference Photo</strong>
                <div class="text-muted small">
                    <a href="<?= $cakeDetails['reference_photo'] ?>" target="_blank">View reference</a>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php if($cakeDetails['notes']): ?>
        <div class="section-title">
            <i class="fas fa-comment me-2"></i>Additional Notes
        </div>
        <div class="p-3 bg-light border rounded">
            <?= nl2br(htmlspecialchars($cakeDetails['notes'])) ?>
        </div>
        <?php endif; ?>
        <?php endif; ?>

        <!-- Payment Information -->
        <div class="section-title">
            <i class="fas fa-credit-card me-2"></i>Payment Information
        </div>
        <div class="detail-row">
            <div class="detail-label">Payment Method:</div>
            <div class="detail-value">
                <?php
                $paymentLabels = [
                    'on_pickup' => 'Payment on Pickup',
                    'deposit' => 'Deposit',
                    'paid' => 'Paid'
                ];
                echo $paymentLabels[$order['payment_method']] ?? ucfirst($order['payment_method']);
                ?>
            </div>
        </div>
        <?php if($order['deposit_amount'] > 0): ?>
        <div class="detail-row">
            <div class="detail-label">Deposit Amount:</div>
            <div class="detail-value"><strong><?= number_format($order['deposit_amount'], 2) ?> PLN</strong></div>
        </div>
        <?php endif; ?>

        <!-- Price Summary -->
        <?php if($cakeDetails && $cakeDetails['total_price'] > 0): ?>
        <div class="price-summary">
            <h5 class="mb-3"><i class="fas fa-calculator me-2"></i>Price Summary</h5>
            <div class="price-row">
                <span>Base Price (Cake):</span>
                <span><?= number_format($cakeDetails['base_price'], 2) ?> PLN</span>
            </div>
            <div class="price-row">
                <span>Extras & Decorations:</span>
                <span><?= number_format($cakeDetails['extras_price'], 2) ?> PLN</span>
            </div>
            <div class="price-row price-total">
                <span>TOTAL:</span>
                <span><?= number_format($cakeDetails['total_price'], 2) ?> PLN</span>
            </div>
        </div>
        <?php endif; ?>

        <!-- Order Information -->
        <div class="mt-5 pt-4 border-top text-muted small">
            <div class="row">
                <div class="col-6">
                    <strong>Order Date:</strong><br>
                    <?= date('F j, Y, H:i', strtotime($order['created_at'])) ?>
                </div>
                <div class="col-6 text-end">
                    <strong>Order Number:</strong><br>
                    #<?= $order['id'] ?>
                </div>
            </div>
        </div>
    </div>
</div>
