<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zamówienie Tortu - Samanta CRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px 0; }
        .cake-form-container { max-width: 900px; margin: 0 auto; }
        .card { border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.2); }
        .form-section { background: #f8f9fa; padding: 15px; border-radius: 10px; margin-bottom: 20px; }
        .form-section h5 { color: #667eea; margin-bottom: 15px; }
        .size-option { cursor: pointer; text-align: center; padding: 15px; border: 2px solid #ddd; border-radius: 10px; transition: all 0.3s; }
        .size-option:hover { border-color: #667eea; transform: translateY(-5px); }
        .size-option input[type="radio"] { display: none; }
        .size-option input[type="radio"]:checked + label { background: #667eea; color: white; }
        .size-option label { cursor: pointer; width: 100%; margin: 0; }
    </style>
</head>
<body>
    <div class="cake-form-container">
        <div class="card">
            <div class="card-header bg-primary text-white text-center py-4">
                <h2><i class="fas fa-birthday-cake me-2"></i>Zamówienie Tortu</h2>
                <p class="mb-0">Wypełnij formularz, aby złożyć zamówienie</p>
            </div>
            <div class="card-body p-4">
                <?php if(isset($_SESSION['success'])): ?>
                    <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
                <?php endif; ?>
                <?php if(isset($_SESSION['error'])): ?>
                    <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
                <?php endif; ?>

                <form method="POST" action="<?= url('cake-order/submit') ?>" enctype="multipart/form-data" id="cakeOrderForm">
                    <!-- Customer Details -->
                    <div class="form-section">
                        <h5><i class="fas fa-user me-2"></i>Dane Zamawiającego</h5>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Imię *</label>
                                <input type="text" name="first_name" class="form-control" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Nazwisko *</label>
                                <input type="text" name="last_name" class="form-control" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Telefon *</label>
                                <input type="tel" name="phone" class="form-control" required>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control">
                            </div>
                        </div>
                    </div>

                    <!-- Pickup Details -->
                    <div class="form-section">
                        <h5><i class="fas fa-map-marker-alt me-2"></i>Odbiór</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Miejsce odbioru *</label>
                                <select name="pickup_location_id" id="pickupLocation" class="form-select" required>
                                    <option value="">-- wybierz --</option>
                                    <?php foreach($locations as $location): ?>
                                        <option value="<?= $location['id'] ?>"><?= htmlspecialchars($location['name']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Data odbioru *</label>
                                <input type="date" name="pickup_date" class="form-control" required min="<?= date('Y-m-d', strtotime('+1 day')) ?>">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Godzina odbioru *</label>
                                <select name="pickup_time" class="form-select" required>
                                    <option value="">-- wybierz --</option>
                                    <?php 
                                    for($h=7; $h<=18; $h++) {
                                        foreach(['00','30'] as $m) {
                                            $time = sprintf('%02d:%s', $h, $m);
                                            echo "<option value='$time'>$time</option>";
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        
                        <div id="deliveryAddress" style="display:none;">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Ulica</label>
                                    <input type="text" name="delivery_street" class="form-control">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Numer</label>
                                    <input type="text" name="delivery_number" class="form-control">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Miasto</label>
                                    <input type="text" name="delivery_city" class="form-control">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Kod pocztowy</label>
                                    <input type="text" name="delivery_postal" class="form-control">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Płatność *</label>
                                <select name="payment_method" id="paymentMethod" class="form-select" required>
                                    <option value="on_pickup">Przy odbiorze</option>
                                    <option value="deposit">Zaliczka</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3" id="depositAmountField" style="display:none;">
                                <label class="form-label">Wartość zaliczki (zł)</label>
                                <input type="number" step="0.01" name="deposit_amount" class="form-control">
                            </div>
                        </div>
                    </div>

                    <!-- Cake Details -->
                    <div class="form-section">
                        <h5><i class="fas fa-birthday-cake me-2"></i>Szczegóły Tortu</h5>
                        
                        <div class="mb-3">
                            <label class="form-label">Smak *</label>
                            <select name="flavor_id" id="flavorSelect" class="form-select" required>
                                <option value="">-- proszę wybrać --</option>
                                <?php foreach($flavors as $flavor): ?>
                                    <option value="<?= $flavor['id'] ?>" <?= $flavor['name'] === 'Inny' ? 'data-other="1"' : '' ?>>
                                        <?= htmlspecialchars($flavor['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="mb-3" id="customFlavorField" style="display:none;">
                            <label class="form-label">Opisz "inny" smak tortu</label>
                            <textarea name="flavor_custom" class="form-control" rows="2"></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Wielkość *</label>
                            <div class="row">
                                <?php foreach($sizes as $size): ?>
                                <div class="col-md-3 col-6 mb-3">
                                    <div class="size-option">
                                        <input type="radio" name="size_id" id="size_<?= $size['id'] ?>" value="<?= $size['id'] ?>" <?= $size['name'] === 'Inny' ? 'data-other="1"' : '' ?> required>
                                        <label for="size_<?= $size['id'] ?>">
                                            <?php if($size['image_url']): ?>
                                                <img src="<?= $size['image_url'] ?>" alt="<?= $size['name'] ?>" style="max-width:80px;max-height:80px;" class="mb-2">
                                            <?php endif; ?>
                                            <div><?= htmlspecialchars($size['name']) ?></div>
                                        </label>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <div class="mb-3" id="customSizeField" style="display:none;">
                            <label class="form-label">Dodatkowe informacje na temat rozmiaru</label>
                            <textarea name="size_custom" class="form-control" rows="2"></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Rodzaj tortu</label>
                            <?php foreach($types as $type): ?>
                            <div class="form-check">
                                <input class="form-check-input cake-type-checkbox" type="checkbox" name="cake_types[]" value="<?= $type['id'] ?>" id="type_<?= $type['id'] ?>" <?= $type['name'] === 'Inny' ? 'data-other="1"' : '' ?>>
                                <label class="form-check-label" for="type_<?= $type['id'] ?>">
                                    <?= htmlspecialchars($type['name']) ?>
                                </label>
                            </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="mb-3" id="customTypeField" style="display:none;">
                            <label class="form-label">Opisz "inny" rodzaj tortu</label>
                            <textarea name="cake_type_custom" class="form-control" rows="2"></textarea>
                        </div>
                    </div>

                    <!-- Decorations -->
                    <div class="form-section">
                        <h5><i class="fas fa-magic me-2"></i>Dekoracje</h5>
                        
                        <div class="row mb-3">
                            <div class="col-md-3">
                                <label class="form-label">Napis</label>
                                <select name="has_inscription" id="hasInscription" class="form-select">
                                    <option value="0">Nie</option>
                                    <option value="1">Tak</option>
                                </select>
                            </div>
                            <div class="col-md-9" id="inscriptionTextField" style="display:none;">
                                <label class="form-label">Treść napisu</label>
                                <input type="text" name="inscription_text" class="form-control">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Świeczki</label>
                                <select name="has_candles" id="hasCandles" class="form-select">
                                    <option value="0">Nie</option>
                                    <option value="1">Tak</option>
                                </select>
                            </div>
                            <div class="col-md-4" id="candlesCountField" style="display:none;">
                                <label class="form-label">Ilość świeczek</label>
                                <input type="number" name="candles_count" class="form-control" min="0">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Świeczka cyfry</label>
                                <select name="has_number_candle" id="hasNumberCandle" class="form-select">
                                    <option value="0">Nie</option>
                                    <option value="1">Tak</option>
                                </select>
                            </div>
                            <div class="col-md-4" id="numberCandleField" style="display:none;">
                                <label class="form-label">Cyfra</label>
                                <input type="number" name="number_candle_value" class="form-control" min="0" max="99">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Raca</label>
                            <select name="has_sparkler" class="form-select">
                                <option value="0">Nie</option>
                                <option value="1">Tak</option>
                            </select>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Opłatek z własnym zdjęciem/grafiką</label>
                                <select name="has_wafer_photo" id="hasWafer" class="form-select">
                                    <option value="0">Nie</option>
                                    <option value="1">Tak</option>
                                </select>
                            </div>
                            <div class="col-md-8" id="waferFileField" style="display:none;">
                                <label class="form-label">Plik / zdjęcie na opłatek</label>
                                <input type="file" name="wafer_file" class="form-control" accept="image/*,.pdf">
                                <small class="text-muted">Można dodać grafikę jeśli jest, ale NIE jest to konieczne.</small>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Kartka/bilecik</label>
                                <select name="has_card" id="hasCard" class="form-select">
                                    <option value="0">Nie</option>
                                    <option value="1">Tak</option>
                                </select>
                            </div>
                            <div class="col-md-8" id="cardTextField" style="display:none;">
                                <label class="form-label">Tekst na bileciku</label>
                                <textarea name="card_text" class="form-control" rows="2"></textarea>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Figurka</label>
                                <select name="has_figurine" id="hasFigurine" class="form-select">
                                    <option value="0">Nie</option>
                                    <option value="1">Tak</option>
                                </select>
                            </div>
                            <div class="col-md-8" id="figurineDescField" style="display:none;">
                                <label class="form-label">Opisz figurkę</label>
                                <textarea name="figurine_description" class="form-control" rows="2"></textarea>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Plik / zdjęcie wzorzec</label>
                            <input type="file" name="reference_photo" class="form-control" accept="image/*,.pdf">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Uwagi</label>
                            <textarea name="notes" class="form-control" rows="3"></textarea>
                        </div>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-paper-plane me-2"></i>Wyślij Zamówienie
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    // Show/hide delivery address
    document.getElementById('pickupLocation').addEventListener('change', function() {
        const selectedText = this.options[this.selectedIndex].text;
        document.getElementById('deliveryAddress').style.display = 
            selectedText.toLowerCase().includes('dostawa') ? 'block' : 'none';
    });

    // Show/hide deposit amount
    document.getElementById('paymentMethod').addEventListener('change', function() {
        document.getElementById('depositAmountField').style.display = 
            this.value === 'deposit' ? 'block' : 'none';
    });

    // Show/hide custom flavor
    document.getElementById('flavorSelect').addEventListener('change', function() {
        document.getElementById('customFlavorField').style.display = 
            this.options[this.selectedIndex].dataset.other ? 'block' : 'none';
    });

    // Show/hide custom size
    document.querySelectorAll('input[name="size_id"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.getElementById('customSizeField').style.display = 
                this.dataset.other ? 'block' : 'none';
        });
    });

    // Show/hide custom type
    document.querySelectorAll('.cake-type-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const anyOtherChecked = Array.from(document.querySelectorAll('.cake-type-checkbox:checked'))
                .some(cb => cb.dataset.other);
            document.getElementById('customTypeField').style.display = 
                anyOtherChecked ? 'block' : 'none';
        });
    });

    // Show/hide inscription text
    document.getElementById('hasInscription').addEventListener('change', function() {
        document.getElementById('inscriptionTextField').style.display = 
            this.value === '1' ? 'block' : 'none';
    });

    // Show/hide candles count
    document.getElementById('hasCandles').addEventListener('change', function() {
        document.getElementById('candlesCountField').style.display = 
            this.value === '1' ? 'block' : 'none';
    });

    // Show/hide number candle
    document.getElementById('hasNumberCandle').addEventListener('change', function() {
        document.getElementById('numberCandleField').style.display = 
            this.value === '1' ? 'block' : 'none';
    });

    // Show/hide wafer file
    document.getElementById('hasWafer').addEventListener('change', function() {
        document.getElementById('waferFileField').style.display = 
            this.value === '1' ? 'block' : 'none';
    });

    // Show/hide card text
    document.getElementById('hasCard').addEventListener('change', function() {
        document.getElementById('cardTextField').style.display = 
            this.value === '1' ? 'block' : 'none';
    });

    // Show/hide figurine description
    document.getElementById('hasFigurine').addEventListener('change', function() {
        document.getElementById('figurineDescField').style.display = 
            this.value === '1' ? 'block' : 'none';
    });
    </script>
</body>
</html>
