<?php

class CakeOrderDetails {
    private $pdo;

    public function __construct() {
        global $pdo;
        $this->pdo = $pdo;
    }

    public function findByOrderId($orderId) {
        $stmt = $this->pdo->prepare("SELECT * FROM cake_order_details WHERE order_id = ?");
        $stmt->execute([$orderId]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create($orderId, $data) {
        $sql = "INSERT INTO cake_order_details (
            order_id, flavor_id, flavor_custom, size_id, size_custom, 
            cake_type_ids, cake_type_custom,
            has_inscription, inscription_text, inscription_price,
            has_candles, candles_price, candles_count, 
            has_number_candle, number_candle_price, number_candle_value, 
            has_sparkler, sparkler_price,
            has_wafer_photo, wafer_photo_price, wafer_file,
            has_card, card_price, card_text, card_pattern,
            has_figurine, figurine_price, figurine_description,
            reference_photo, notes,
            base_price, extras_price, total_price
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([
            $orderId,
            $data['flavor_id'] ?? null,
            $data['flavor_custom'] ?? null,
            $data['size_id'] ?? null,
            $data['size_custom'] ?? null,
            $data['cake_type_ids'] ?? null,
            $data['cake_type_custom'] ?? null,
            $data['has_inscription'] ?? 0,
            $data['inscription_text'] ?? null,
            $data['inscription_price'] ?? 0,
            $data['has_candles'] ?? 0,
            $data['candles_price'] ?? 0,
            $data['candles_count'] ?? 0,
            $data['has_number_candle'] ?? 0,
            $data['number_candle_price'] ?? 0,
            $data['number_candle_value'] ?? null,
            $data['has_sparkler'] ?? 0,
            $data['sparkler_price'] ?? 0,
            $data['has_wafer_photo'] ?? 0,
            $data['wafer_photo_price'] ?? 0,
            $data['wafer_file'] ?? null,
            $data['has_card'] ?? 0,
            $data['card_price'] ?? 0,
            $data['card_text'] ?? null,
            $data['card_pattern'] ?? null,
            $data['has_figurine'] ?? 0,
            $data['figurine_price'] ?? 0,
            $data['figurine_description'] ?? null,
            $data['reference_photo'] ?? null,
            $data['notes'] ?? null,
            $data['base_price'] ?? 0,
            $data['extras_price'] ?? 0,
            $data['total_price'] ?? 0
        ]);
    }

    public function update($orderId, $data) {
        // First check if exists
        $existing = $this->findByOrderId($orderId);
        
        if (!$existing) {
            return $this->create($orderId, $data);
        }
        
        $sql = "UPDATE cake_order_details SET 
            flavor_id = ?, flavor_custom = ?, size_id = ?, size_custom = ?,
            cake_type_ids = ?, cake_type_custom = ?,
            has_inscription = ?, inscription_text = ?,
            has_candles = ?, candles_count = ?, has_number_candle = ?, number_candle_value = ?, has_sparkler = ?,
            has_wafer_photo = ?, wafer_file = ?,
            has_card = ?, card_text = ?, card_pattern = ?,
            has_figurine = ?, figurine_description = ?,
            reference_photo = ?, notes = ?
        WHERE order_id = ?";
        
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([
            $data['flavor_id'] ?? null,
            $data['flavor_custom'] ?? null,
            $data['size_id'] ?? null,
            $data['size_custom'] ?? null,
            $data['cake_type_ids'] ?? null,
            $data['cake_type_custom'] ?? null,
            $data['has_inscription'] ?? 0,
            $data['inscription_text'] ?? null,
            $data['has_candles'] ?? 0,
            $data['candles_count'] ?? 0,
            $data['has_number_candle'] ?? 0,
            $data['number_candle_value'] ?? null,
            $data['has_sparkler'] ?? 0,
            $data['has_wafer_photo'] ?? 0,
            $data['wafer_file'] ?? null,
            $data['has_card'] ?? 0,
            $data['card_text'] ?? null,
            $data['card_pattern'] ?? null,
            $data['has_figurine'] ?? 0,
            $data['figurine_description'] ?? null,
            $data['reference_photo'] ?? null,
            $data['notes'] ?? null,
            $orderId
        ]);
    }

    public function delete($orderId) {
        $stmt = $this->pdo->prepare("DELETE FROM cake_order_details WHERE order_id = ?");
        return $stmt->execute([$orderId]);
    }
}
