<?php
require_once '../app/Models/CakeFlavor.php';
require_once '../app/Models/CakeSize.php';
require_once '../app/Models/CakeType.php';
require_once '../app/Models/PickupLocation.php';
require_once '../app/Models/CakeFlavorPricing.php';

class CakeFeaturesController {
    private $flavorModel;
    private $sizeModel;
    private $typeModel;
    private $locationModel;
    private $pricingModel;

    public function __construct() {
        if (!isset($_SESSION['user_id'])) { redirect('login'); exit; }
        if (($_SESSION['user_role'] ?? '') !== 'admin') { 
            $_SESSION['error'] = 'Admin only.'; 
            redirect('dashboard'); 
            exit; 
        }
        
        $this->flavorModel = new CakeFlavor();
        $this->sizeModel = new CakeSize();
        $this->typeModel = new CakeType();
        $this->locationModel = new PickupLocation();
        $this->pricingModel = new CakeFlavorPricing();
    }

    public function index() {
        $flavors = $this->flavorModel->all(false);
        $sizes = $this->sizeModel->all(false);
        $types = $this->typeModel->all(false);
        $locations = $this->locationModel->all(false);
        $pricing = $this->pricingModel->all();
        
        $this->view('cake_features/index', compact('flavors', 'sizes', 'types', 'locations', 'pricing'));
    }

    // Flavors
    public function createFlavor() {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'name_en' => trim($_POST['name_en'] ?? ''),
            'image_url' => trim($_POST['image_url'] ?? ''),
            'sort_order' => (int)($_POST['sort_order'] ?? 0),
            'active' => isset($_POST['active']) ? 1 : 0
        ];
        
        if (empty($data['name'])) {
            $_SESSION['error'] = 'Name is required';
            redirect('cake-features');
            exit;
        }
        
        $this->flavorModel->create($data);
        $_SESSION['success'] = 'Flavor created';
        redirect('cake-features');
    }

    public function updateFlavor($id) {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'name_en' => trim($_POST['name_en'] ?? ''),
            'image_url' => trim($_POST['image_url'] ?? ''),
            'sort_order' => (int)($_POST['sort_order'] ?? 0),
            'active' => isset($_POST['active']) ? 1 : 0
        ];
        
        $this->flavorModel->update($id, $data);
        $_SESSION['success'] = 'Flavor updated';
        redirect('cake-features');
    }

    public function deleteFlavor($id) {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        $this->flavorModel->delete($id);
        $_SESSION['success'] = 'Flavor deleted';
        redirect('cake-features');
    }

    // Sizes
    public function createSize() {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'name_en' => trim($_POST['name_en'] ?? ''),
            'image_url' => trim($_POST['image_url'] ?? ''),
            'sort_order' => (int)($_POST['sort_order'] ?? 0),
            'active' => isset($_POST['active']) ? 1 : 0
        ];
        
        $this->sizeModel->create($data);
        $_SESSION['success'] = 'Size created';
        redirect('cake-features');
    }

    public function updateSize($id) {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'name_en' => trim($_POST['name_en'] ?? ''),
            'image_url' => trim($_POST['image_url'] ?? ''),
            'sort_order' => (int)($_POST['sort_order'] ?? 0),
            'active' => isset($_POST['active']) ? 1 : 0
        ];
        
        $this->sizeModel->update($id, $data);
        $_SESSION['success'] = 'Size updated';
        redirect('cake-features');
    }

    public function deleteSize($id) {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        $this->sizeModel->delete($id);
        $_SESSION['success'] = 'Size deleted';
        redirect('cake-features');
    }

    // Types
    public function createType() {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'name_en' => trim($_POST['name_en'] ?? ''),
            'price' => (float)($_POST['price'] ?? 0),
            'sort_order' => (int)($_POST['sort_order'] ?? 0),
            'active' => isset($_POST['active']) ? 1 : 0
        ];
        
        $this->typeModel->create($data);
        $_SESSION['success'] = 'Type created';
        redirect('cake-features');
    }

    public function updateType($id) {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'name_en' => trim($_POST['name_en'] ?? ''),
            'price' => (float)($_POST['price'] ?? 0),
            'sort_order' => (int)($_POST['sort_order'] ?? 0),
            'active' => isset($_POST['active']) ? 1 : 0
        ];
        
        $this->typeModel->update($id, $data);
        $_SESSION['success'] = 'Type updated';
        redirect('cake-features');
    }

    public function deleteType($id) {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        $this->typeModel->delete($id);
        $_SESSION['success'] = 'Type deleted';
        redirect('cake-features');
    }

    // Locations
    public function createLocation() {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'address' => trim($_POST['address'] ?? ''),
            'sort_order' => (int)($_POST['sort_order'] ?? 0),
            'active' => isset($_POST['active']) ? 1 : 0
        ];
        
        $this->locationModel->create($data);
        $_SESSION['success'] = 'Location created';
        redirect('cake-features');
    }

    public function updateLocation($id) {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'address' => trim($_POST['address'] ?? ''),
            'sort_order' => (int)($_POST['sort_order'] ?? 0),
            'active' => isset($_POST['active']) ? 1 : 0
        ];
        
        $this->locationModel->update($id, $data);
        $_SESSION['success'] = 'Location updated';
        redirect('cake-features');
    }

    public function deleteLocation($id) {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        $this->locationModel->delete($id);
        $_SESSION['success'] = 'Location deleted';
        redirect('cake-features');
    }

    // Flavor Pricing
    public function updatePricing() {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') { redirect('cake-features'); exit; }
        
        $pricing = $_POST['pricing'] ?? [];
        
        foreach ($pricing as $flavorId => $sizes) {
            foreach ($sizes as $sizeId => $price) {
                $this->pricingModel->setPrice((int)$flavorId, (int)$sizeId, (float)$price);
            }
        }
        
        $_SESSION['success'] = 'Pricing updated';
        redirect('cake-features');
    }

    private function view($view, $data = []) {
        extract($data);
        $title = 'Cake Features';
        ob_start();
        require_once "../app/Views/{$view}.php";
        $content = ob_get_clean();
        require_once '../app/Views/layout.php';
    }
}
