<?php
require_once __DIR__ . '/bootstrap/db.php';

echo "=== Analyzing Location Data ===\n\n";

// Check orders table structure first
echo "1. Orders table structure:\n";
$ordersCols = $pdo->query("SHOW COLUMNS FROM orders")->fetchAll(PDO::FETCH_ASSOC);
$locationCol = null;
foreach ($ordersCols as $col) {
    if (stripos($col['Field'], 'location') !== false || stripos($col['Field'], 'lokal') !== false) {
        echo "  - {$col['Field']} ({$col['Type']})\n";
        $locationCol = $col['Field'];
    }
}

if ($locationCol) {
    echo "\n2. Orders locations from '$locationCol':\n";
    $ordersLocations = $pdo->query("SELECT DISTINCT $locationCol FROM orders WHERE $locationCol IS NOT NULL AND $locationCol != '' ORDER BY $locationCol")->fetchAll(PDO::FETCH_COLUMN);
    foreach ($ordersLocations as $loc) {
        echo "  - $loc\n";
    }
    echo "\nTotal distinct order locations: " . count($ordersLocations) . "\n";
} else {
    echo "\n2. No location column found in orders table\n";
    $ordersLocations = [];
}

// Check products table
echo "\n3. Products table structure:\n";
$cols = $pdo->query("SHOW COLUMNS FROM products")->fetchAll(PDO::FETCH_ASSOC);
$hasLocation = false;
foreach ($cols as $col) {
    if (stripos($col['Field'], 'location') !== false || stripos($col['Field'], 'lokal') !== false) {
        echo "  - {$col['Field']} ({$col['Type']})\n";
        $hasLocation = true;
    }
}
if (!$hasLocation) {
    echo "  - No location-related columns found\n";
}

// Menu locations for reference
echo "\n4. Menu locations (for mapping):\n";
$menuLocations = [
    'Słoneczna 1',
    'Witkiewicza 2',
    'Krupówki 4a',
    'Kościelisko',
    'Kasprusie 34',
    'Chramcówki 4',
    'Pardałówka'
];
foreach ($menuLocations as $loc) {
    echo "  - $loc\n";
}

// Try to match
echo "\n5. Attempting to match locations:\n";
if (!empty($ordersLocations)) {
    foreach ($ordersLocations as $orderLoc) {
        $matched = false;
        foreach ($menuLocations as $menuLoc) {
            if (stripos($menuLoc, $orderLoc) !== false || stripos($orderLoc, $menuLoc) !== false) {
                echo "  ✓ '$orderLoc' matches '$menuLoc'\n";
                $matched = true;
                break;
            }
        }
        if (!$matched) {
            echo "  ✗ '$orderLoc' - no match found\n";
        }
    }
} else {
    echo "  No order locations to match\n";
}

echo "\n✅ Done!\n";
