<?php
/**
 * Add external_id column to orders table for migration tracking
 */

require_once __DIR__ . '/bootstrap/db.php';

try {
    // Check if column already exists
    $stmt = $pdo->query("SHOW COLUMNS FROM orders LIKE 'external_id'");
    $exists = $stmt->fetch();
    
    if (!$exists) {
        echo "Adding external_id column to orders table...\n";
        $pdo->exec("ALTER TABLE orders ADD COLUMN external_id VARCHAR(100) NULL AFTER id");
        $pdo->exec("CREATE INDEX idx_orders_external_id ON orders(external_id)");
        echo "✓ Added external_id column with index\n";
    } else {
        echo "✓ external_id column already exists\n";
    }
    
    echo "\nDone!\n";
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}
