<?php
if (!defined('ABSPATH')) {
    exit;
}

// Prepare grouped items by category
$groupedItems = array();
foreach ($menu_data['categories'] as $category) {
    $groupedItems[$category['name']] = array(
        'name_en' => $category['name_en'] ?? '',
        'description' => $category['description'] ?? '',
        'description_en' => $category['description_en'] ?? '',
        'items' => $category['items']
    );
}

$location_id = $menu_data['location']['id'];
?>

<!-- Menu Header (Sticky) -->
<div class="samanta-menu-header" data-aos="fade-down" data-aos-duration="500">
    <div class="menu-heading d-flex justify-content-between align-items-center">
        <div>
            <h1 class="menu-title mb-0" data-aos="fade-right" data-aos-delay="50">
                <?php echo esc_html($menu_data['location']['name']); ?>
            </h1>
            <?php if (!empty($groupedItems)): ?>
                <nav class="category-nav" data-aos="fade-up" data-aos-delay="150">
                    <?php foreach (array_keys($groupedItems) as $categoryName): ?>
                        <a href="#category-<?php echo urlencode($categoryName); ?>" class="category-nav-link">
                            <span class="lang-text lang-pl"><?php echo esc_html($categoryName); ?></span>
                            <span class="lang-text lang-en" style="display: none;"><?php echo esc_html($groupedItems[$categoryName]['name_en'] ?: $categoryName); ?></span>
                        </a>
                    <?php endforeach; ?>
                </nav>
            <?php endif; ?>
        </div>
        <div class="lang-pill" data-aos="zoom-in" data-aos-delay="120" onclick="samantaToggleLanguage()" title="Przełącz język / Switch language">
            <img src="https://www.cukierniasamanta.pl/sklep/wp-content/uploads/2022/08/Poland_flag_icon_round-copy.svg" 
                 alt="Polish flag" 
                 class="lang-flag" 
                 id="samantaLangFlag">
        </div>
    </div>
</div>

<!-- Menu Categories -->
<?php if (empty($groupedItems)): ?>
    <div class="menu-wrapper" data-aos="fade-up">
        <div class="text-center py-5">
            <p class="text-muted">Brak pozycji menu dla tej lokalizacji</p>
        </div>
    </div>
<?php else: ?>
    <?php 
    $categoryIndex = 0;
    foreach ($groupedItems as $categoryName => $categoryData): 
        $categoryIndex++;
        $items = $categoryData['items'];
    ?>
        <div class="menu-wrapper" data-aos="fade-up" data-aos-duration="700" data-aos-delay="<?php echo $categoryIndex * 100; ?>" id="category-<?php echo urlencode($categoryName); ?>">
            <h2 class="section-title">
                <span class="lang-text lang-pl"><?php echo esc_html($categoryName); ?></span>
                <span class="lang-text lang-en" style="display: none;"><?php echo esc_html($categoryData['name_en'] ?: $categoryName); ?></span>
            </h2>
            
            <div class="menu-items">
                <?php 
                $itemIndex = 0;
                foreach ($items as $item): 
                    $itemIndex++;
                    $hasImage = !empty($item['image_url']);
                    
                    // Prepare price data
                    $prices = array();
                    if (!empty($item['prices'])) {
                        foreach ($item['prices'] as $priceData) {
                            $prices[] = array(
                                'label_pl' => $priceData['variant_name'] ?? '',
                                'label_en' => $priceData['variant_name_en'] ?? $priceData['variant_name'] ?? '',
                                'value' => $priceData['price']
                            );
                        }
                    }
                ?>
                    <div class="menu-item" 
                         data-aos="fade-up" 
                         data-aos-delay="<?php echo 80 + ($itemIndex * 50); ?>" 
                         data-item-id="<?php echo esc_attr($item['id']); ?>"
                         data-name-pl="<?php echo esc_attr($item['name']); ?>"
                         data-name-en="<?php echo esc_attr($item['name_en'] ?? ''); ?>"
                         data-desc-pl="<?php echo esc_attr($item['description'] ?? ''); ?>"
                         data-desc-en="<?php echo esc_attr($item['description_en'] ?? ''); ?>"
                         onclick="samantaToggleCartItem(this, event)">
                        <button class="remove-item-btn" onclick="samantaRemoveFromCart(this, event)" title="Usuń z wyboru">×</button>
                        <div class="row g-3 align-items-center">
                            <?php if ($hasImage): ?>
                                <div class="col-4 col-md-3">
                                    <img src="<?php echo esc_url($item['image_url']); ?>"
                                         alt="<?php echo esc_attr($item['name']); ?>" 
                                         class="menu-item-img w-100"
                                         onclick="samantaOpenLightbox(this, event)"
                                         data-lightbox-data='<?php echo esc_attr(json_encode(array(
                                             'title_pl' => $item['name'],
                                             'title_en' => $item['name_en'] ?? '',
                                             'subtitle_pl' => $item['name_en'] ?? '',
                                             'subtitle_en' => $item['name'],
                                             'desc_pl' => $item['description'] ?? '',
                                             'desc_en' => $item['description_en'] ?? '',
                                             'prices' => $prices
                                         ))); ?>'>
                                </div>
                                <div class="col-8 col-md-7">
                            <?php else: ?>
                                <div class="col-9 col-sm-10">
                            <?php endif; ?>
                                    <div class="menu-item-title">
                                        <span class="lang-text lang-pl"><?php echo esc_html($item['name']); ?></span>
                                        <span class="lang-text lang-en" style="display: none;"><?php echo esc_html($item['name_en'] ?: $item['name']); ?></span>
                                    </div>
                                    <?php if (!empty($item['name_en'])): ?>
                                        <div class="menu-item-subtitle">
                                            <span class="lang-text lang-pl"><?php echo esc_html($item['name_en']); ?></span>
                                            <span class="lang-text lang-en" style="display: none;"><?php echo esc_html($item['name']); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (!empty($item['description'])): ?>
                                        <div class="menu-item-desc">
                                            <span class="lang-text lang-pl"><?php echo esc_html($item['description']); ?></span>
                                            <span class="lang-text lang-en" style="display: none;"><?php echo esc_html($item['description_en'] ?: $item['description']); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="<?php echo $hasImage ? 'col-12 col-md-2' : 'col-3 col-sm-2'; ?> text-<?php echo $hasImage ? 'md-' : ''; ?>end <?php echo $hasImage ? 'mt-2 mt-md-0' : ''; ?>">
                                    <?php if (!empty($prices)): ?>
                                        <?php foreach ($prices as $idx => $price): ?>
                                            <?php if ($idx > 0): ?>
                                                <div class="mt-2"></div>
                                            <?php endif; ?>
                                            <?php if (!empty($price['label_pl'])): ?>
                                                <div class="menu-item-price-label">
                                                    <span class="lang-text lang-pl"><?php echo esc_html($price['label_pl']); ?></span>
                                                    <span class="lang-text lang-en" style="display: none;"><?php echo esc_html($price['label_en'] ?: $price['label_pl']); ?></span>
                                                </div>
                                            <?php endif; ?>
                                            <div class="menu-item-price"><?php echo number_format($price['value'], 0); ?> zł</div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endforeach; ?>
<?php endif; ?>

<!-- Floating Buttons -->
<div class="floating-buttons">
    <button class="floating-btn" id="samantaCartBtn" title="Wybrane pozycje" style="position: relative;">
        🛒
        <span class="cart-badge" id="samantaCartBadge">0</span>
    </button>
    <button class="floating-btn" id="samantaMenuBtn" title="Menu kategorii">
        ☰
    </button>
    <button class="floating-btn" id="samantaScrollTopBtn" title="Przewiń do góry">
        ↑
    </button>
</div>

<!-- Category Menu Popup -->
<?php if (!empty($groupedItems)): ?>
<div class="category-menu-popup" id="samantaCategoryMenuPopup">
    <h6>Przejdź do kategorii:</h6>
    <?php foreach (array_keys($groupedItems) as $categoryName): ?>
        <a href="#category-<?php echo urlencode($categoryName); ?>" class="category-nav-link popup-category-link">
            <span class="lang-text lang-pl"><?php echo esc_html($categoryName); ?></span>
            <span class="lang-text lang-en" style="display: none;"><?php echo esc_html($groupedItems[$categoryName]['name_en'] ?: $categoryName); ?></span>
        </a>
    <?php endforeach; ?>
</div>
<?php endif; ?>

<!-- Lightbox -->
<div class="lightbox" id="samantaLightbox" onclick="samantaCloseLightbox(event)">
    <button class="lightbox-close" onclick="samantaCloseLightbox(event)">&times;</button>
    <div class="lightbox-content" onclick="event.stopPropagation()">
        <img src="" alt="" class="lightbox-image" id="samantaLightboxImage">
        <div class="lightbox-details">
            <div class="lightbox-title" id="samantaLightboxTitle"></div>
            <div class="lightbox-subtitle" id="samantaLightboxSubtitle"></div>
            <div class="lightbox-desc" id="samantaLightboxDesc"></div>
            <div class="lightbox-prices" id="samantaLightboxPrices"></div>
        </div>
    </div>
</div>

<!-- Cart View -->
<div class="cart-view" id="samantaCartView">
    <div class="cart-header">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h1 class="menu-title mb-0">Wybrane pozycje</h1>
                <p class="text-muted mb-0 mt-2" id="samantaCartCount">0 pozycji</p>
            </div>
            <div class="d-flex" style="position: relative;">
                <button class="share-btn" id="samantaShareBtn" onclick="samantaToggleShareMenu()" title="Udostępnij">
                    📤
                </button>
                <div class="share-menu" id="samantaShareMenu">
                    <a href="#" class="share-option" onclick="samantaShareViaWhatsApp(event)">
                        <span class="share-icon">💬</span>
                        <span>WhatsApp</span>
                    </a>
                    <a href="#" class="share-option" onclick="samantaShareViaSMS(event)">
                        <span class="share-icon">📱</span>
                        <span>SMS</span>
                    </a>
                    <a href="#" class="share-option" onclick="samantaShareViaEmail(event)">
                        <span class="share-icon">✉️</span>
                        <span>Email</span>
                    </a>
                    <a href="#" class="share-option" onclick="samantaShareViaMessenger(event)">
                        <span class="share-icon">👥</span>
                        <span>Messenger</span>
                    </a>
                </div>
                <button class="cart-close-btn" onclick="samantaCloseCartView()" title="Zamknij">
                    ×
                </button>
            </div>
        </div>
    </div>
    <div id="samantaCartContent"></div>
</div>

<script>
    // Pass location ID and name to JavaScript
    window.samantaMenuData = {
        locationId: <?php echo json_encode($location_id); ?>,
        locationName: <?php echo json_encode($menu_data['location']['name']); ?>
    };
</script>
