jQuery(document).ready(function($) {
    
    // Upload form submission
    $('#samanta-upload-form').on('submit', function(e) {
        e.preventDefault();
        
        var formData = new FormData();
        var fileInput = $('#menu-file')[0];
        
        if (fileInput.files.length === 0) {
            showMessage('Wybierz plik JSON', 'error');
            return;
        }
        
        formData.append('menu_file', fileInput.files[0]);
        formData.append('action', 'samanta_upload_menu');
        formData.append('nonce', samantaMenu.nonce);
        
        showMessage('Wgrywanie...', 'info');
        
        $.ajax({
            url: samantaMenu.ajax_url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    showMessage('Menu wgrane pomyślnie: ' + response.data.location, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showMessage('Błąd: ' + response.data, 'error');
                }
            },
            error: function() {
                showMessage('Błąd połączenia z serwerem', 'error');
            }
        });
    });
    
    // Delete menu
    $('.delete-menu').on('click', function() {
        if (!confirm('Czy na pewno chcesz usunąć to menu?')) {
            return;
        }
        
        var locationId = $(this).data('location');
        var $row = $(this).closest('tr');
        
        $.ajax({
            url: samantaMenu.ajax_url,
            type: 'POST',
            data: {
                action: 'samanta_delete_menu',
                nonce: samantaMenu.nonce,
                location_id: locationId
            },
            success: function(response) {
                if (response.success) {
                    $row.fadeOut(400, function() {
                        $(this).remove();
                    });
                } else {
                    alert('Błąd: ' + response.data);
                }
            }
        });
    });
    
    // Copy shortcode
    $('.copy-shortcode').on('click', function() {
        var shortcode = $(this).data('shortcode');
        navigator.clipboard.writeText(shortcode).then(function() {
            alert('Shortcode skopiowany!');
        });
    });
    
    function showMessage(message, type) {
        var className = type === 'success' ? 'success-message' : 
                       type === 'error' ? 'error-message' : 'info-message';
        
        $('#upload-message').html('<div class="' + className + '">' + message + '</div>');
    }
});
