<?php
if (!defined('ABSPATH')) {
    exit;
}

$menus = get_option('samanta_menu_data', array());
?>

<div class="wrap">
    <h1>Menu Lokali - Zarządzanie</h1>
    
    <div class="card" style="max-width: 800px; margin: 20px 0;">
        <h2>Wgraj nowe menu</h2>
        <p>Wgraj plik JSON wyeksportowany z systemu CRM</p>
        
        <form id="samanta-upload-form" style="margin: 20px 0;">
            <input type="file" id="menu-file" name="menu_file" accept=".json" required>
            <button type="submit" class="button button-primary" style="margin-left: 10px;">Wgraj Menu</button>
        </form>
        
        <div id="upload-message" style="margin-top: 15px;"></div>
    </div>
    
    <div class="card" style="max-width: 1200px;">
        <h2>Aktualne Menu</h2>
        
        <?php if (empty($menus)): ?>
            <p>Brak wgranych menu. Wgraj pierwszy plik JSON.</p>
        <?php else: ?>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>ID Lokalizacji</th>
                        <th>Nazwa Lokalizacji</th>
                        <th>Adres</th>
                        <th>Liczba Kategorii</th>
                        <th>Liczba Produktów</th>
                        <th>Shortcode</th>
                        <th>Akcje</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($menus as $location_id => $menu): ?>
                        <tr>
                            <td><?php echo esc_html($location_id); ?></td>
                            <td><?php echo esc_html($menu['location']['name']); ?></td>
                            <td><?php echo esc_html($menu['location']['address'] ?? ''); ?></td>
                            <td><?php echo count($menu['categories']); ?></td>
                            <td>
                                <?php 
                                $item_count = 0;
                                foreach ($menu['categories'] as $cat) {
                                    $item_count += count($cat['items']);
                                }
                                echo $item_count;
                                ?>
                            </td>
                            <td>
                                <code>[samanta_menu location="<?php echo esc_attr($location_id); ?>"]</code>
                                <button class="button button-small copy-shortcode" data-shortcode='[samanta_menu location="<?php echo esc_attr($location_id); ?>"]'>Kopiuj</button>
                            </td>
                            <td>
                                <button class="button button-small button-danger delete-menu" data-location="<?php echo esc_attr($location_id); ?>">Usuń</button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <div style="margin-top: 20px; padding: 15px; background: #f0f0f1; border-left: 4px solid #2271b1;">
                <h3>Jak używać:</h3>
                <ol>
                    <li><strong>Lista lokalizacji:</strong> Użyj <code>[samanta_locations]</code> aby wyświetlić przycisk wyboru lokalizacji</li>
                    <li><strong>Konkretne menu:</strong> Użyj <code>[samanta_menu location="ID"]</code> aby wyświetlić menu dla konkretnej lokalizacji</li>
                    <li><strong>Dynamiczne menu:</strong> Shortcode <code>[samanta_menu]</code> wyświetli menu na podstawie parametru URL <code>?location=ID</code></li>
                </ol>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.card {
    background: white;
    padding: 20px;
    margin: 20px 0;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.button-danger {
    background: #dc3545;
    border-color: #dc3545;
    color: white;
}

.button-danger:hover {
    background: #c82333;
    border-color: #bd2130;
    color: white;
}

.success-message {
    padding: 10px;
    background: #d4edda;
    border: 1px solid #c3e6cb;
    color: #155724;
    border-radius: 4px;
}

.error-message {
    padding: 10px;
    background: #f8d7da;
    border: 1px solid #f5c6cb;
    color: #721c24;
    border-radius: 4px;
}
</style>
