# Samanta Menu Display - WordPress Plugin

Plugin do wyświetlania menu restauracji na stronie WordPress. Pozwala na import danych menu z systemu CRM w formacie JSON.

## Instalacja

1. Skopiuj folder `samanta-menu` do katalogu `/wp-content/plugins/` w instalacji WordPress
2. Przejdź do panelu administracyjnego WordPress → Wtyczki
3. Aktywuj wtyczkę "Samanta Menu Display"

## Jak używać

### 1. Wgranie menu do WordPressa

1. W systemie CRM przejdź do: **Menu → Wersje**
2. Wybierz lokalizację z listy
3. Kliknij "Utwórz nową wersję"
4. Kliknij "Pobierz JSON" aby pobrać plik menu
5. W WordPress przejdź do: **Menu Lokali**
6. Użyj formularza "Wgraj nowe menu" aby załadować plik JSON
7. Menu zostanie automatycznie dodane do systemu

### 2. Wyświetlanie menu na stronie

Plugin udostępnia 2 shortcody:

#### Shortcode: Lista lokalizacji
```
[samanta_locations]
```
Wyświetla przycisk wyboru lokalizacji dla wszystkich wgranych menu.

#### Shortcode: Konkretne menu
```
[samanta_menu location="1"]
```
Wyświetla menu dla konkretnej lokalizacji (zamień `1` na ID lokalizacji).

#### Shortcode: Dynamiczne menu
```
[samanta_menu]
```
Wyświetla menu na podstawie parametru URL `?location=ID`

### 3. Przykładowa konfiguracja stron

**Strona: "Nasze Menu" (np. /menu)**
- Dodaj shortcode: `[samanta_locations]`
- Użytkownicy zobaczą listę lokalizacji do wyboru

**Strona: "Menu - Automatyczne" (np. /menu-view)**
- Dodaj shortcode: `[samanta_menu]`
- Menu będzie wyświetlane dynamicznie na podstawie parametru URL
- Link z listy lokalizacji przekieruje na: `/menu-view?location=1`

**Alternatywnie: Osobne strony dla każdej lokalizacji**
- Strona "Menu - Warszawa": `[samanta_menu location="1"]`
- Strona "Menu - Kraków": `[samanta_menu location="2"]`

## Funkcje

### Panel administracyjny
- Wgrywanie plików JSON z menu
- Podgląd wszystkich wgranych menu
- Wyświetlanie liczby kategorii i produktów
- Kopiowanie shortcodów do schowka
- Usuwanie nieaktualnych menu

### Wyświetlanie menu
- **Dwujęzyczność**: Przełączanie PL/EN
- **Responsywność**: Dostosowanie do urządzeń mobilnych
- **Animacje**: Płynne efekty przewijania (AOS)
- **Nawigacja**: Szybki dostęp do kategorii
- **Sticky menu**: Nawigacja przypięta podczas przewijania
- **Ceny**: Wyświetlanie wariantów cenowych
- **Alergeny**: Oznaczenie alergenów w produktach

### Dane przechowywane w menu
- Nazwa i adres lokalizacji
- Kategorie menu (PL + EN)
- Produkty z opisami (PL + EN)
- Warianty cenowe
- Informacje o alergenach
- Numer wersji menu

## Struktura plików

```
samanta-menu/
├── samanta-menu.php          # Główny plik wtyczki
├── admin/
│   └── admin-page.php        # Panel administracyjny
├── assets/
│   ├── admin.css             # Style panelu admin
│   ├── admin.js              # JavaScript panelu admin
│   ├── menu.css              # Style wyświetlania menu
│   └── menu.js               # JavaScript menu (animacje, język)
└── templates/
    ├── locations.php         # Szablon listy lokalizacji
    └── menu-display.php      # Szablon wyświetlania menu
```

## Wymagania

- WordPress 5.0 lub nowszy
- PHP 7.2 lub nowszy

## Zewnętrzne biblioteki

Plugin korzysta z CDN dla następujących bibliotek:
- Bootstrap 5.3.3
- AOS (Animate On Scroll) 2.3.4

## Aktualizacja menu

Aby zaktualizować menu dla lokalizacji:
1. W CRM wygeneruj nowy plik JSON
2. W WordPress wgraj nowy plik przez panel "Menu Lokali"
3. Nowe menu automatycznie zastąpi poprzednie dla tej lokalizacji

## Wsparcie

W przypadku problemów sprawdź:
- Czy plik JSON ma prawidłową strukturę
- Czy w WordPress Console nie ma błędów JavaScript
- Czy shortcode jest poprawnie wpisany
- Czy wtyczka jest aktywowana

## Autor

Samanta CRM System
Wersja: 1.0.0
