<?php
// Test translation function
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

require_once 'bootstrap/env.php';
require_once 'bootstrap/db.php';
require_once 'bootstrap/translator.php';

// Initialize session language if not set
if (!isset($_SESSION['language'])) {
    $_SESSION['language'] = 'en';
}

echo "Testing Translation System\n";
echo "=========================\n\n";

// Test 1: Check if function exists
if (function_exists('__')) {
    echo "✓ Translation function __ exists\n";
} else {
    echo "✗ Translation function __ NOT found\n";
    exit(1);
}

// Test 2: Try to get current language
try {
    $currentLang = Translation::getCurrentLanguage();
    echo "✓ Current language: $currentLang\n";
} catch (Exception $e) {
    echo "✗ Error getting current language: " . $e->getMessage() . "\n";
}

// Test 3: Test translation function
try {
    $result = __('dashboard.title', 'Dashboard');
    echo "✓ Translation test: dashboard.title = '$result'\n";
} catch (Exception $e) {
    echo "✗ Translation error: " . $e->getMessage() . "\n";
}

// Test 4: Test with non-existent key
try {
    $result = __('non.existent.key', 'Default Value');
    echo "✓ Fallback test: non.existent.key = '$result'\n";
} catch (Exception $e) {
    echo "✗ Fallback error: " . $e->getMessage() . "\n";
}

echo "\nTest complete!\n";
