<?php
session_start();

echo "<h2>Session Debug Information</h2>";

echo "<h3>Session Status:</h3>";
echo "<p><strong>Session ID:</strong> " . session_id() . "</p>";
echo "<p><strong>Session Status:</strong> " . session_status() . " (2 = active)</p>";

echo "<h3>Session Data:</h3>";
if (empty($_SESSION)) {
    echo "<p style='color: red;'>❌ Session is empty</p>";
} else {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Key</th><th>Value</th></tr>";
    foreach ($_SESSION as $key => $value) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($key) . "</td>";
        echo "<td>" . htmlspecialchars(is_array($value) ? json_encode($value) : $value) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<h3>Authentication Check:</h3>";
if (isset($_SESSION['user_id'])) {
    echo "<p style='color: green;'>✅ User is logged in</p>";
    echo "<p><strong>User ID:</strong> " . $_SESSION['user_id'] . "</p>";
    echo "<p><strong>User Name:</strong> " . ($_SESSION['user_name'] ?? 'Not set') . "</p>";
    echo "<p><strong>User Role:</strong> " . ($_SESSION['user_role'] ?? 'Not set') . "</p>";
} else {
    echo "<p style='color: red;'>❌ User is NOT logged in</p>";
}

echo "<h3>Test Database Connection:</h3>";
try {
    require_once '../bootstrap/db.php';
    echo "<p style='color: green;'>✅ Database connection successful</p>";
    
    if (isset($_SESSION['user_id'])) {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch();
        
        if ($user) {
            echo "<p style='color: green;'>✅ User exists in database</p>";
            echo "<p><strong>Database User:</strong> " . htmlspecialchars($user['name']) . " (" . htmlspecialchars($user['email']) . ")</p>";
        } else {
            echo "<p style='color: red;'>❌ User not found in database</p>";
        }
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Database connection failed: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>Navigation Links:</h3>";
echo "<p><a href='/samanta_crm/login'>Login Page</a></p>";
echo "<p><a href='/samanta_crm/logout'>Logout</a></p>";
echo "<p><a href='/samanta_crm/dashboard'>Dashboard (may redirect)</a></p>";
?>
