<?php
/**
 * Force-create all translation keys used in panel.php
 * Visit this page once to populate all translation keys
 */

// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once __DIR__ . '/../bootstrap/env.php';
require_once __DIR__ . '/../bootstrap/db.php';
require_once __DIR__ . '/../app/helpers/translation.php';

// Set language to Polish
$_SESSION['language'] = 'pl';

echo "<!DOCTYPE html><html><head><title>Generate Translations</title></head><body>";
echo "<h1>Generating Translation Keys...</h1>";
echo "<p><strong>Current Language:</strong> " . ($_SESSION['language'] ?? 'not set') . "</p>";
echo "<p><strong>AUTO_CREATE_TRANSLATIONS:</strong> " . (defined('AUTO_CREATE_TRANSLATIONS') ? (AUTO_CREATE_TRANSLATIONS ? 'TRUE' : 'FALSE') : 'NOT DEFINED') . "</p>";
echo "<ul>";

// All translation keys from panel.php
$keys = [
    // Header & Form
    ['orders.tablet_create_order', 'Odbiorca - Create Order'],
    ['orders.tablet_panel', 'Tablet Order'],
    ['common.select', 'Select'],
    ['common.customer', 'Customer'],
    ['orders.date', 'Date'],
    ['orders.delivery', 'Delivery'],
    ['orders.assigned_to', 'Assigned To'],
    ['common.notes', 'Notes'],
    
    // Search & Controls
    ['common.search_products', 'Search products...'],
    ['common.cards', 'Cards'],
    ['common.list', 'List'],
    ['common.selected', 'Selected'],
    
    // Category
    ['common.uncategorized', 'Uncategorized'],
    
    // Summary Panel
    ['orders.order_summary', 'Order Summary'],
    ['orders.empty_cart', 'No items added yet'],
    ['orders.total_items', 'Total Items'],
    ['orders.submit', 'Submit Order'],
    
    // JavaScript Messages
    ['orders.add_items', 'Please add at least one item'],
    ['orders.submitting', 'Submitting order...'],
];

foreach ($keys as $key) {
    $result = __($key[0], $key[1]);
    echo "<li><strong>{$key[0]}</strong>: {$result}</li>";
}

echo "</ul>";
echo "<h2>✓ Done! All keys created.</h2>";
echo "<p><a href='/samanta_crm/languages/11/translations'>View Polish Translations</a></p>";
echo "</body></html>";
